<div>
    <div class="d-flex justify-content-between mb-3">
        <h2>Invoice Management</h2>
        <button class="btn btn-primary" wire:click="openCreateModal">New Invoice</button>
    </div>

    <div class="card mt-4">
        <div class="card-body">
            <!-- Search Input -->
            <div class="d-flex justify-content-between align-items-center mb-4">
                <input 
                    type="text" 
                    class="form-control w-50" 
                    placeholder="Search invoices..." 
                    wire:model.live="searchQuery" 
                />
            </div>

            <div class="table-responsive mt-4">
                <table class="table table-border table-hover">
                    <thead>
                        <tr>
                            <th>Invoice #</th>
                            <th>Patient</th>
                            <th>Date</th>
                            <th>Total</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($invoice->invoice_number); ?></td>
                                <td><?php echo e($invoice->patient->name); ?> (<?php echo e($invoice->patient->code); ?>)</td>
                                <td><?php echo e($invoice->invoice_date->format('Y-m-d')); ?></td>
                                <td><?php echo e(number_format($invoice->total_amount, 2)); ?></td>
                                <td class="text-center">
                                    <div role="group" class="btn-group">
                                        <button wire:click="openEditModal(<?php echo e($invoice->id); ?>)"
                                            type="button" class="btn btn-icon btn-outline-primary m-1">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <a href="<?php echo e(route('invoices.show', $invoice->id)); ?>">
                                            <button type="button" class="btn btn-icon btn-outline-info m-1">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-between align-items-center mt-4">
                <div>
                    <p class="mb-0">Total: <?php echo e($invoices->total()); ?></p>
                </div>
                <div>
                    <?php echo e($invoices->links(data: ['scrollTo' => false])); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Create Invoice Modal -->
    <?php if($showCreateModal): ?>
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">New Invoice</h5>
                    <button type="button" class="btn-close" wire:click="closeCreateModal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <select class="form-select" id="patient_id" wire:model="patient_id" required>
                                    <option value="">Select Patient</option>
                                    <?php $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($patient->id); ?>"><?php echo e($patient->name); ?> (<?php echo e($patient->code); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <label for="patient_id">Patient</label>
                                <?php $__errorArgs = ['patient_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="date" class="form-control" id="invoice_date" wire:model="invoice_date" required>
                                <label for="invoice_date">Invoice Date</label>
                                <?php $__errorArgs = ['invoice_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mb-3">
                            <div class="form-floating">
                                <textarea class="form-control" id="notes" wire:model="notes" style="height: 100px" placeholder="Notes"></textarea>
                                <label for="notes">Notes</label>
                                <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeCreateModal">Close</button>
                    <button wire:click="saveInvoice" type="button" class="btn btn-primary">Create Invoice</button>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Edit Invoice Modal -->
    <?php if($showEditModal && $currentInvoice): ?>
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Invoice: <?php echo e($currentInvoice->invoice_number); ?></h5>
                    <button type="button" class="btn-close" wire:click="closeEditModal"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="form-floating">
                                <select class="form-select" wire:model="patient_id" required>
                                    <option value="">Select Patient</option>
                                    <?php $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($patient->id); ?>"><?php echo e($patient->name); ?> (<?php echo e($patient->code); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <label>Patient</label>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between mb-3">
                        <h6>Invoice Items</h6>
                        <button class="btn btn-sm btn-primary" wire:click="openAddItemModal">Add Item</button>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Item</th>
                                    <th>Quantity</th>
                                    <th>Unit Price</th>
                                    <th>Total</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $invoiceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($item['subcategory_id'] ? 'Service' : 'Drug'); ?></td>
                                        <td>
                                            <?php if($item['subcategory_id']): ?>
                                                <?php echo e(\App\Models\Subcategory::find($item['subcategory_id'])->name ?? '-'); ?>

                                            <?php else: ?>
                                                <?php echo e(\App\Models\Product::find($item['product_id'])->name ?? '-'); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($item['quantity']); ?></td>
                                        <td><?php echo e(number_format($item['unit_price'], 2)); ?></td>
                                        <td><?php echo e(number_format($item['total_price'], 2)); ?></td>
                                        <td>
                                            <button wire:click="removeInvoiceItem(<?php echo e($item['id']); ?>)"
                                                wire:confirm="Are you sure?"
                                                class="btn btn-sm btn-danger">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="4" class="text-end">Total:</th>
                                    <th><?php echo e(number_format($currentInvoice->total_amount ?? 0, 2)); ?></th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeEditModal">Close</button>
                    <button wire:click="updateInvoice" type="button" class="btn btn-primary">Save Invoice</button>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Add Item Modal -->
    <?php if($showAddItemModal): ?>
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Invoice Item</h5>
                    <button type="button" class="btn-close" wire:click="closeAddItemModal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label>Item Type</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" wire:model.live="item_type" id="type_service" value="service">
                                <label class="form-check-label" for="type_service">Service</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" wire:model.live="item_type" id="type_drug" value="drug">
                                <label class="form-check-label" for="type_drug">Drug</label>
                            </div>
                        </div>

                        <?php if($item_type === 'service'): ?>
                            <div class="col-md-6 mb-3">
                                <div class="form-floating">
                                    <select class="form-select" wire:model.live="item_category_id">
                                        <option value="">Select Category</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($category->type === 'service' || $category->type === 'other'): ?>
                                                <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <label>Category</label>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-floating">
                                    <select class="form-select" wire:model.live="item_subcategory_id">
                                        <option value="">Select Subcategory</option>
                                        <?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($subcategory->id); ?>"><?php echo e($subcategory->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <label>Subcategory</label>
                                    <?php $__errorArgs = ['item_subcategory_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="col-md-6 mb-3">
                                <div class="form-floating">
                                    <select class="form-select" wire:model.live="item_category_id">
                                        <option value="">Select Category</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($category->type === 'drug'): ?>
                                                <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <label>Category</label>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-floating">
                                    <select class="form-select" wire:model.live="item_product_id">
                                        <option value="">Select Product</option>
                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($product->id); ?>"><?php echo e($product->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <label>Product</label>
                                    <?php $__errorArgs = ['item_product_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-floating">
                                    <select class="form-select" wire:model="item_product_batch_id">
                                        <option value="">Select Batch</option>
                                        <?php $__currentLoopData = $productBatches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($batch->id); ?>">
                                                Batch: <?php echo e($batch->batch_number ?? 'N/A'); ?> 
                                                (Available: <?php echo e($batch->quantity - $batch->sold_quantity + $batch->returned_quantity); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <label>Product Batch</label>
                                    <?php $__errorArgs = ['item_product_batch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="number" class="form-control" wire:model="item_quantity" min="1" step="1" required>
                                <label>Quantity</label>
                                <?php $__errorArgs = ['item_quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="number" class="form-control" wire:model="item_unit_price" min="0" step="0.01" required>
                                <label>Unit Price</label>
                                <?php $__errorArgs = ['item_unit_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mb-3">
                            <div class="form-floating">
                                <textarea class="form-control" wire:model="item_notes" style="height: 80px"></textarea>
                                <label>Notes</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeAddItemModal">Close</button>
                    <button wire:click="addInvoiceItem" type="button" class="btn btn-primary">Add Item</button>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php /**PATH C:\Dev\doublehair\resources\views\livewire\invoice-management.blade.php ENDPATH**/ ?>