<div>
    <style>
        .stat-card {
            border-radius: 12px;
            transition: all 0.3s ease;
            border: none;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }
        .stat-icon i {
            font-size: 24px !important;
        }
        .stat-value {
            font-size: 28px;
            font-weight: 700;
            margin: 10px 0 5px 0;
        }
        .stat-label {
            font-size: 14px;
            color: #6c757d;
            font-weight: 500;
        }
        .filter-card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .table-card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
    </style>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="mb-0">Product Report</h2>
    </div>

    <!-- Analysis Cards -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card stat-card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Total Products</div>
                            <div class="stat-value"><?php echo e(number_format($analysis['total_products'])); ?></div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-package"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Stock Value</div>
                            <div class="stat-value"><?php echo e(number_format($analysis['filtered_stock_value'], 2)); ?></div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-currency-dollar"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Sales Value</div>
                            <div class="stat-value"><?php echo e(number_format($analysis['filtered_sales_value'], 2)); ?></div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-chart-line"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Low Stock Items</div>
                            <div class="stat-value"><?php echo e(number_format($analysis['low_stock_count'])); ?></div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-alert-triangle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters Card -->
    <div class="card filter-card mb-4">
        <div class="card-header bg-white border-bottom py-3 d-flex justify-content-between align-items-center">
            <h5 class="mb-0 text-primary"><i class="ti ti-filter me-2"></i>Filters</h5>
            <button wire:click="resetFilters" class="btn btn-outline-secondary btn-sm">
                <i class="ti ti-refresh me-1"></i> Reset
            </button>
        </div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Search</label>
                    <input type="text" wire:model.live.debounce.300ms="search" class="form-control" 
                           placeholder="Search by name or description...">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Supplier</label>
                    <select wire:model.live="supplier_id" class="form-select">
                        <option value="">All Suppliers</option>
                        <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Stock Status</label>
                    <select wire:model.live="stockFilter" class="form-select">
                        <option value="all">All Products</option>
                        <option value="in_stock">In Stock</option>
                        <option value="low_stock">Low Stock (< 10)</option>
                        <option value="out_of_stock">Out of Stock</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Sort By</label>
                    <select wire:model.live="sortBy" class="form-select">
                        <option value="created_at">Date</option>
                        <option value="name">Name</option>
                        <option value="stock_quantity">Stock</option>
                        <option value="sale_price">Price</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Table Card -->
    <div class="card table-card">
        <div class="card-header bg-white border-bottom py-3">
            <h5 class="mb-0"><i class="ti ti-table me-2"></i>Products List</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th wire:click="sortByField('name')" style="cursor: pointer;">
                                Product Name
                                <?php if($sortBy === 'name'): ?>
                                    <i class="ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th>Supplier</th>
                            <th wire:click="sortByField('stock_quantity')" style="cursor: pointer;">
                                Stock
                                <?php if($sortBy === 'stock_quantity'): ?>
                                    <i class="ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th wire:click="sortByField('sale_price')" style="cursor: pointer;">
                                Sale Price
                                <?php if($sortBy === 'sale_price'): ?>
                                    <i class="ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th>Purchase Price</th>
                            <th>Items Sold</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><strong><?php echo e($product->name); ?></strong></td>
                                <td><?php echo e($product->supplier->name ?? '-'); ?></td>
                                <td>
                                    <?php if($product->stock_quantity > 10): ?>
                                        <span class="badge bg-success"><?php echo e($product->stock_quantity); ?></span>
                                    <?php elseif($product->stock_quantity > 0): ?>
                                        <span class="badge bg-warning"><?php echo e($product->stock_quantity); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">0</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(number_format($product->sale_price, 2)); ?></td>
                                <td><?php echo e($product->purchase_price ? number_format($product->purchase_price, 2) : '-'); ?></td>
                                <td>
                                    <span class="badge bg-info"><?php echo e($product->invoice_items_count); ?></span>
                                </td>
                                <td>
                                    <?php if($product->stock_quantity > 10): ?>
                                        <span class="badge bg-success">In Stock</span>
                                    <?php elseif($product->stock_quantity > 0): ?>
                                        <span class="badge bg-warning">Low Stock</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Out of Stock</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('products.show', $product->id)); ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="ti ti-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <i class="ti ti-inbox ti-2x text-muted mb-2"></i>
                                    <p class="text-muted">No products found</p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer bg-white border-top">
            <?php echo e($products->links()); ?>

        </div>
    </div>
</div>

<?php /**PATH C:\Dev\doublehair\resources\views\livewire\product-report.blade.php ENDPATH**/ ?>