<?php
$configData = Helper::appClasses();
$user = Auth::user();
$isSuperAdmin = $user->hasRole('super-admin');
$isUser = $user->hasRole('user');
?>

<style>
/* Modern Vertical Menu Design - Beauty Center Colors */
#layout-menu {
  background: linear-gradient(180deg, #fff5f7 0%, #ffffff 100%) !important;
  border-right: 1px solid rgba(236, 72, 153, 0.1) !important;
  box-shadow: 4px 0 30px rgba(236, 72, 153, 0.1) !important;
  transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
}

.dark-style #layout-menu {
  background: linear-gradient(180deg, #1a1d29 0%, #252836 100%) !important;
  border-right-color: rgba(255, 255, 255, 0.08) !important;
  box-shadow: 4px 0 30px rgba(0, 0, 0, 0.4) !important;
}

/* Override theme CSS */
.layout-menu.menu-vertical.menu.bg-menu-theme {
  background: linear-gradient(180deg, #fff5f7 0%, #ffffff 100%) !important;
}

.dark-style .layout-menu.menu-vertical.menu.bg-menu-theme {
  background: linear-gradient(180deg, #1e2028 0%, #252836 100%) !important;
}

/* Force override for all possible selectors */
aside#layout-menu.layout-menu.menu-vertical.menu.bg-menu-theme {
  background: linear-gradient(180deg, #fff5f7 0%, #ffffff 100%) !important;
}

.dark-style aside#layout-menu.layout-menu.menu-vertical.menu.bg-menu-theme {
  background: linear-gradient(180deg, #1e2028 0%, #252836 100%) !important;
}

/* Force dark mode for body and html */
.dark-style body,
.dark-style html {
  background-color: #1e2028 !important;
}

/* Override bg-menu-theme class */
.bg-menu-theme {
  background: linear-gradient(180deg, #fff5f7 0%, #ffffff 100%) !important;
}

.dark-style .bg-menu-theme {
  background: linear-gradient(180deg, #1e2028 0%, #252836 100%) !important;
}

/* Override any theme-specific backgrounds */
.menu.bg-menu-theme {
  background: linear-gradient(180deg, #fff5f7 0%, #ffffff 100%) !important;
}

.dark-style .menu.bg-menu-theme {
  background: linear-gradient(180deg, #1e2028 0%, #252836 100%) !important;
}

/* Additional override for menu container */
.menu-vertical {
  background: linear-gradient(180deg, #fff5f7 0%, #ffffff 100%) !important;
}

.dark-style .menu-vertical {
  background: linear-gradient(180deg, #1e2028 0%, #252836 100%) !important;
}

/* Dark mode for menu container */
.dark-style .layout-menu {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
}

/* Dark mode for menu inner */
.dark-style .menu-inner {
  background: transparent !important;
}

/* Dark mode for menu items */
.dark-style .menu-item {
  background: transparent !important;
}

.dark-style .menu-item .menu-link {
  color: #ddd !important;
  background: transparent !important;
}

.dark-style .menu-item .menu-link:hover {
  background: #db2777;
  color: #f9a8d4 !important;
}

/* Dark Mode Menu Item Hover - Dark Pink */
.dark-style .menu-item .menu-link:hover {
  background: #db2777;
}

/* Dark Mode Active Menu Item */
.dark-style .menu-item.active .menu-link {
  background: #db2777;
}

/* Dark Mode Menu Header Text */
.dark-style .menu-header-text {
  color: #f9a8d4 !important;
}

/* Dark mode for menu headers */
.dark-style .menu-header {
  background: #db2777;
  border-left-color: #f472b6 !important;
}

/* Dark mode for menu icons */
.dark-style .menu-icon {
  color: #f472b6 !important;
}

/* Dark mode for active menu items - Brown */
.dark-style .menu-item.active {
  background: #db2777;
}

.dark-style .menu-item.active .menu-link {
  color: white !important;
}

.dark-style .menu-item.active .menu-icon {
  color: white !important;
}

/* Dark Mode App Brand */
.dark-style .app-brand {
  background: #db2777;
}

/* Dark mode for app brand text */
.dark-style .app-brand-text {
  color: white !important;
}

.dark-style .app-brand-link {
  color: white !important;
}

.dark-style .app-brand-link * {
  color: white !important;
}

/* Dark Mode Menu Shadow */
.dark-style .menu-inner-shadow {
  background: linear-gradient(180deg, rgba(47,51,73,0.8) 0%, transparent 100%);
}

/* Dark Mode Menu Divider */
.menu-divider {
  height: 1px;
  background: linear-gradient(90deg, transparent, #e0e0e0, transparent);
  margin: 0.75rem 1.25rem;
}

.dark-style .menu-divider {
  background: linear-gradient(90deg, transparent, #3e4054, transparent);
}

/* App Brand Styling - Beauty Center Pink/Rose Gold */
.app-brand {
  background: linear-gradient(135deg, #ec4899 0%, #f472b6 30%, #f9a8d4 60%, #ec4899 100%);
  border-radius: 0 0 24px 24px;
  margin: 0 12px 24px 12px;
  padding: 24px 20px;
  box-shadow: 0 8px 32px rgba(236, 72, 153, 0.3), 
              0 2px 8px rgba(236, 72, 153, 0.2),
              inset 0 1px 0 rgba(255, 255, 255, 0.2);
  transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
  position: relative;
  overflow: hidden;
}

.app-brand::before {
  content: '';
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);
  transition: left 0.5s ease;
}

.app-brand:hover::before {
  left: 100%;
}

.app-brand:hover {
  transform: translateY(-3px);
  box-shadow: 0 12px 40px rgba(236, 72, 153, 0.4), 
              0 4px 12px rgba(236, 72, 153, 0.25),
              inset 0 1px 0 rgba(255, 255, 255, 0.25);
}

.app-brand-link {
  text-decoration: none;
  color: white !important;
  display: flex;
  align-items: center;
  gap: 12px;
}

.app-brand-link * {
  color: white !important;
}

/* Override any theme colors */
.app-brand-text.demo.menu-text.fw-bolder.ms-2.text-white {
  color: white !important;
  text-shadow: none !important;
}

span.app-brand-text.demo.menu-text.fw-bolder.ms-2.text-white {
  color: white !important;
  text-shadow: none !important;
}

.app-brand-logo {
  width: 40px;
  height: 40px;
  border-radius: 10px;
  overflow: hidden;
  background: rgba(255, 255, 255, 0.2);
  padding: 5px;
  transition: transform 0.3s ease;
}

.app-brand:hover .app-brand-logo {
  transform: scale(1.1);
}

.app-brand-text {
  font-size: 1.25rem;
  font-weight: 700;
  color: white !important;
  text-shadow: none !important;
}

.app-brand-text.text-white {
  color: white !important;
  text-shadow: none !important;
}

.app-brand-text.demo {
  color: white !important;
  text-shadow: none !important;
}

.app-brand-text.demo.text-white {
  color: white !important;
  text-shadow: none !important;
}

.layout-menu-toggle {
  background: rgba(255, 255, 255, 0.15);
  border-radius: 10px;
  padding: 10px;
  color: white;
  transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
  backdrop-filter: blur(10px);
  border: 1px solid rgba(255, 255, 255, 0.1);
}

.layout-menu-toggle:hover {
  background: rgba(255, 255, 255, 0.25);
  transform: scale(1.08) rotate(5deg);
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
}

/* Menu Items Styling - Modern Card Design */
.menu-inner {
  padding: 0 16px 24px 16px;
}

.menu-item {
  margin-bottom: 6px;
  border-radius: 14px;
  overflow: hidden;
  transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
  position: relative;
}

.menu-item::before {
  content: '';
  position: absolute;
  left: 0;
  top: 0;
  width: 4px;
  height: 100%;
  background: linear-gradient(180deg, #ec4899 0%, #f472b6 100%);
  transform: scaleY(0);
  transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
  border-radius: 0 4px 4px 0;
}

.menu-item.active::before {
  background: linear-gradient(180deg, #6d301e 0%, #8b3d2a 100%);
}

.menu-item:hover {
  transform: translateX(6px);
  box-shadow: 0 6px 20px rgba(219, 39, 119, 0.25),
              0 2px 8px rgba(219, 39, 119, 0.18);
}

.menu-item:hover::before {
  background: linear-gradient(180deg, #db2777 0%, #ec4899 100%);
  transform: scaleY(1);
}



.menu-item.active::before {
  background: rgba(255, 255, 255, 0.2);
  transform: scaleY(1);
}

.menu-item.active .menu-link {
  color: white;
  font-weight: 600;
}

.menu-item.active .menu-icon {
  color: white;
  transform: scale(1.15);
}

.menu-link {
  padding: 14px 18px;
  border-radius: 14px;
  display: flex;
  align-items: center;
  gap: 14px;
  color: #2d3748;
  text-decoration: none;
  transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
  position: relative;
  overflow: hidden;
  background: transparent;
}

/* Dark Pink Hover State */
.menu-link:hover {
  background: linear-gradient(135deg, rgba(219, 39, 119, 0.15) 0%, rgba(236, 72, 153, 0.1) 100%);
  color: #db2777;
}

.dark-style .menu-link {
  color: #e2e8f0;
}

.dark-style .menu-link:hover {
  background: linear-gradient(135deg, rgba(219, 39, 119, 0.25) 0%, rgba(236, 72, 153, 0.2) 100%);
  color: #f9a8d4;
}

.menu-icon {
  font-size: 1.3rem;
  color: #ec4899;
  transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
  min-width: 24px;
  display: flex;
  align-items: center;
  justify-content: center;
  width: 24px;
  height: 24px;
}

.menu-item:hover .menu-icon {
  color: #db2777;
  transform: scale(1.1) rotate(5deg);
}

.menu-item.active .menu-icon {
  color: white;
}

.menu-item.active .menu-icon {
  color: white;
}

.menu-link div {
  font-weight: 500;
  font-size: 0.95rem;
  transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
  letter-spacing: 0.2px;
}

.menu-item:hover .menu-link div {
  font-weight: 600;
  color: #db2777;
}

.menu-item.active .menu-link div {
  color: white;
}

.dark-style .menu-item:hover .menu-link div {
  color: #f9a8d4;
}

/* Menu Headers - Beauty Center Pink */
.menu-header {
  margin: 32px 0 16px 0;
  padding: 10px 18px;
  background: linear-gradient(135deg, rgba(236, 72, 153, 0.12) 0%, rgba(249, 168, 212, 0.08) 100%);
  border-radius: 12px;
  border-left: 4px solid #ec4899;
  position: relative;
  backdrop-filter: blur(10px);
}

.menu-header::after {
  content: '';
  position: absolute;
  right: 18px;
  top: 50%;
  transform: translateY(-50%);
  width: 6px;
  height: 6px;
  background: #ec4899;
  border-radius: 50%;
  opacity: 0.7;
  box-shadow: 0 0 8px rgba(236, 72, 153, 0.5);
}

.dark-style .menu-header {
  background: linear-gradient(135deg, rgba(236, 72, 153, 0.25) 0%, rgba(236, 72, 153, 0.15) 100%);
  border-left-color: #f472b6;
}

.menu-header-text {
  font-weight: 700;
  font-size: 0.75rem;
  color: #ec4899;
  letter-spacing: 1px;
  text-transform: uppercase;
  position: relative;
  z-index: 1;
}

.dark-style .menu-header-text {
  color: #f9a8d4;
}

/* Submenu Styling - Beauty Center Pink */
.menu-sub {
  background: linear-gradient(135deg, rgba(236, 72, 153, 0.08) 0%, rgba(249, 168, 212, 0.04) 100%);
  border-radius: 12px;
  margin: 10px 0 10px 24px;
  padding: 10px 0;
  border-left: 3px solid rgba(236, 72, 153, 0.3);
  backdrop-filter: blur(5px);
}

.dark-style .menu-sub {
  background: linear-gradient(135deg, rgba(236, 72, 153, 0.2) 0%, rgba(236, 72, 153, 0.1) 100%);
  border-left-color: rgba(244, 114, 182, 0.5);
}

.menu-sub .menu-item {
  margin: 3px 10px;
}

.menu-sub .menu-link {
  padding: 10px 14px;
  font-size: 0.9rem;
}

.menu-sub .menu-icon {
  font-size: 1.1rem;
}

/* Menu Toggle Animation */
.menu-toggle-icon {
  transition: transform 0.3s ease;
}

.menu-item.open .menu-toggle-icon {
  transform: rotate(90deg);
}

/* Menu Shadow */
.menu-inner-shadow {
  background: linear-gradient(180deg, rgba(0, 0, 0, 0.1) 0%, transparent 100%);
  height: 20px;
  margin: 0 -15px;
  border-radius: 0 0 15px 15px;
}

.dark-style .menu-inner-shadow {
  background: linear-gradient(180deg, rgba(0, 0, 0, 0.3) 0%, transparent 100%);
}

/* Responsive Design */
@media (max-width: 1199.98px) {
  .app-brand {
    margin: 0 5px 15px 5px;
    padding: 15px;
  }
  
  .menu-inner {
    padding: 0 10px 15px 10px;
  }
  
  .menu-link {
    padding: 10px 12px;
  }
}

@media (max-width: 575.98px) {
  .app-brand-text {
    font-size: 1rem;
  }
  
  .menu-link {
    padding: 8px 10px;
  }
  
  .menu-icon {
    font-size: 1.1rem;
  }
}

/* Smooth Scrollbar - Modern Design */
.menu-inner::-webkit-scrollbar {
  width: 6px;
}

.menu-inner::-webkit-scrollbar-track {
  background: rgba(109, 48, 30, 0.05);
  border-radius: 10px;
  margin: 8px 0;
}

.menu-inner::-webkit-scrollbar-thumb {
  background: linear-gradient(180deg, #ec4899 0%, #f472b6 100%);
  border-radius: 10px;
  transition: background 0.3s ease;
}

.menu-inner::-webkit-scrollbar-thumb:hover {
  background: linear-gradient(180deg, #f472b6 0%, #ec4899 100%);
}

/* Loading Animation - Smooth Entrance */
@keyframes menuSlideIn {
  from {
    opacity: 0;
    transform: translateX(-30px) scale(0.95);
  }
  to {
    opacity: 1;
    transform: translateX(0) scale(1);
  }
}

.menu-item {
  animation: menuSlideIn 0.4s cubic-bezier(0.4, 0, 0.2, 1) backwards;
}

.menu-item:nth-child(1) { animation-delay: 0.05s; }
.menu-item:nth-child(2) { animation-delay: 0.1s; }
.menu-item:nth-child(3) { animation-delay: 0.15s; }
.menu-item:nth-child(4) { animation-delay: 0.2s; }
.menu-item:nth-child(5) { animation-delay: 0.25s; }
.menu-item:nth-child(6) { animation-delay: 0.3s; }
.menu-item:nth-child(7) { animation-delay: 0.35s; }
.menu-item:nth-child(8) { animation-delay: 0.4s; }

/* FINAL OVERRIDE - Must be at the end */
/* Force sidebar background override */
aside#layout-menu,
aside#layout-menu.layout-menu,
aside#layout-menu.menu-vertical,
aside#layout-menu.menu,
aside#layout-menu.bg-menu-theme,
aside#layout-menu.layout-menu.menu-vertical.menu.bg-menu-theme {
  background: linear-gradient(180deg, #fff5f7 0%, #ffffff 100%) !important;
}

.dark-style aside#layout-menu,
.dark-style aside#layout-menu.layout-menu,
.dark-style aside#layout-menu.menu-vertical,
.dark-style aside#layout-menu.menu,
.dark-style aside#layout-menu.bg-menu-theme,
.dark-style aside#layout-menu.layout-menu.menu-vertical.menu.bg-menu-theme {
  background: linear-gradient(180deg, #1e2028 0%, #252836 100%) !important;
}

/* Nuclear option - override everything */
*[id="layout-menu"] {
  background: linear-gradient(180deg, #fff5f7 0%, #ffffff 100%) !important;
}

.dark-style *[id="layout-menu"] {
  background: linear-gradient(180deg, #1e2028 0%, #252836 100%) !important;
}

/* Alternative dark mode selectors */
html[data-theme="dark"] #layout-menu,
html.dark-style #layout-menu,
body.dark-style #layout-menu,
.dark-style #layout-menu {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
}

/* Force dark mode for testing */
#layout-menu.dark-mode {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
}
</style>

<aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">

  <!-- ! Hide app brand if navbar-full -->
  <?php if(!isset($navbarFull)): ?>
  <div class="app-brand demo">
    <a href="<?php echo e(url('/')); ?>" class="app-brand-link">
      <span class="app-brand-logo demo">
        <img src="/assets/logoback.png" style="width: 100%; height:100%;">
      </span>
      <span class=" text-white demo menu-text fw-bolder ms-2">LA DERMA</span>
    </a>

    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
      <i class="ti ti-chevrons-left menu-toggle-icon d-none d-xl-block ti-sm align-middle"></i>
      <i class="ti ti-x d-block d-xl-none ti-sm align-middle"></i>
    </a>
  </div>
  <?php endif; ?>

  <div class="menu-inner-shadow"></div>

  <ul class="menu-inner py-1">
    <!-- Dashboard -->
    <li class="menu-item <?php echo e((request()->segment(1) == '') ? 'active' : ''); ?>">
      <a href="/" class="menu-link">
        <i class="menu-icon tf-icons ti ti-dashboard"></i>
        <div><?php echo app('translator')->get('word.Dashboard'); ?></div>
      </a>
    </li>

    <?php if($isSuperAdmin): ?>

    <!-- Patient Management Section -->
    <li class="menu-header small text-uppercase bg-lighter">
      <span class="menu-header-text">Patient Management</span>
    </li>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Patient::class)): ?>
    <li class="menu-item <?php echo e(request()->is('patients*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('patients.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-users"></i>
        <div>Patients</div>
      </a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Invoice::class)): ?>
    <li class="menu-item <?php echo e(request()->is('invoices*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('invoices.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-receipt"></i>
        <div>Invoices</div>
      </a>
    </li>
    <?php endif; ?>


    <!-- Products & Services Section -->
    <li class="menu-header small text-uppercase bg-lighter">
      <span class="menu-header-text">Products & Services</span>
    </li>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Category::class)): ?>
    <li class="menu-item <?php echo e(request()->is('categories*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('categories.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-category"></i>
        <div>Services</div>
      </a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Subcategory::class)): ?>
    <li class="menu-item <?php echo e(request()->is('subcategories*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('subcategories.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-list"></i>
        <div>Services Categories</div>
      </a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Product::class)): ?>
    <li class="menu-item <?php echo e(request()->is('products*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('products.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-package"></i>
        <div>Products</div>
      </a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Supplier::class)): ?>
    <li class="menu-item <?php echo e(request()->is('suppliers*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('suppliers.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-truck"></i>
        <div>Suppliers</div>
      </a>
    </li>
    <?php endif; ?>


    <!-- Reports Section -->
    <li class="menu-header small text-uppercase bg-lighter">
      <span class="menu-header-text">Reports</span>
    </li>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Patient::class)): ?>
    <li class="menu-item <?php echo e(request()->is('reports/patients*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('reports.patients')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-chart-line"></i>
        <div>Patient Report</div>
      </a>
    </li>
    <?php endif; ?>

    <li class="menu-item <?php echo e(request()->is('reports/products*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('reports.products')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-chart-pie"></i>
        <div>Product Report</div>
      </a>
    </li>

    <li class="menu-item <?php echo e(request()->is('reports/invoices*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('reports.invoices')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-file-text"></i>
        <div>Invoice Report</div>
      </a>
    </li>


    <!-- System Section -->
    <li class="menu-header small text-uppercase bg-lighter">
      <span class="menu-header-text">System</span>
    </li>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', Spatie\Activitylog\Models\Activity::class)): ?>
    <li class="menu-item <?php echo e((request()->segment(1) == 'logs') ? 'active' : ''); ?>">
      <a href="/logs" class="menu-link">
        <i class="menu-icon tf-icons ti ti-file-analytics"></i>
        <div><?php echo app('translator')->get('word.SystemLogs'); ?></div>
      </a>
    </li>
    <?php endif; ?>

    <?php if(Auth::user()->can('view-any', Spatie\Permission\Models\Role::class) ||
      Auth::user()->can('view-any', Spatie\Permission\Models\Permission::class)): ?>
      <li class="menu-header small text-uppercase bg-lighter">
        <span class="menu-header-text"><?php echo app('translator')->get('word.User'); ?></span>
      </li>

      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', Spatie\Permission\Models\User::class)): ?>
      <li class="menu-item <?php echo e(request()->segment(1) == 'users' ? 'active' : ''); ?>">
        <a href="<?php echo e(route('users.index')); ?>" class="menu-link">
          <i class="menu-icon tf-icons ti ti-users-group"></i>
          <div><?php echo app('translator')->get('word.User'); ?></div>
        </a>
      </li>
      <?php endif; ?>

    
    <?php endif; ?>

    <?php endif; ?>

    <!-- User Menu Section - Show for users with patient/invoice permissions -->
    <?php if(!$isSuperAdmin && (Auth::user()->can('view-any', App\Models\Patient::class) || Auth::user()->can('view-any', App\Models\Invoice::class))): ?>

    <!-- Patient Management Section -->
    <li class="menu-header small text-uppercase bg-lighter">
      <span class="menu-header-text">Patient Management</span>
    </li>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Patient::class)): ?>
    <li class="menu-item <?php echo e(request()->is('patients*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('patients.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-users"></i>
        <div>Patients</div>
      </a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Invoice::class)): ?>
    <li class="menu-item <?php echo e(request()->is('invoices*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('invoices.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-receipt"></i>
        <div>Invoices</div>
      </a>
    </li>
    <?php endif; ?>

    <!-- Reports Section -->
    <li class="menu-header small text-uppercase bg-lighter">
      <span class="menu-header-text">Reports</span>
    </li>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Patient::class)): ?>
    <li class="menu-item <?php echo e(request()->is('reports/patients*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('reports.patients')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-chart-line"></i>
        <div>Patient Report</div>
      </a>
    </li>
    <?php endif; ?>

    <?php endif; ?>

 
  </ul>
</aside>

<script>
// Debug and force dark mode
document.addEventListener('DOMContentLoaded', function() {
  console.log('Menu loaded, checking dark mode...');
  
  // Check current theme
  const htmlElement = document.documentElement;
  const bodyElement = document.body;
  const menuElement = document.getElementById('layout-menu');
  
  console.log('HTML classes:', htmlElement.className);
  console.log('HTML data-theme:', htmlElement.getAttribute('data-theme'));
  console.log('HTML data-style:', htmlElement.getAttribute('data-style'));
  console.log('Body classes:', bodyElement.className);
  
  // Force dark mode if needed
  function checkAndApplyDarkMode() {
    const isDarkMode = htmlElement.classList.contains('dark-style');
    
    console.log('HTML classes:', htmlElement.className);
    console.log('Is dark mode:', isDarkMode);
    
    if (isDarkMode) {
      menuElement.classList.add('dark-mode');
      console.log('Applied dark mode to menu');
    } else {
      menuElement.classList.remove('dark-mode');
      console.log('Removed dark mode from menu');
    }
  }
  
  // Check initially
  checkAndApplyDarkMode();
  
  // Watch for theme changes
  const observer = new MutationObserver(function(mutations) {
    mutations.forEach(function(mutation) {
      if (mutation.type === 'attributes' && 
          (mutation.attributeName === 'class' || 
           mutation.attributeName === 'data-theme' || 
           mutation.attributeName === 'data-style')) {
        console.log('Theme changed, rechecking...');
        checkAndApplyDarkMode();
      }
    });
  });
  
  observer.observe(htmlElement, {
    attributes: true,
    attributeFilter: ['class', 'data-theme', 'data-style']
  });
  
  observer.observe(bodyElement, {
    attributes: true,
    attributeFilter: ['class']
  });
});
</script><?php /**PATH C:\Dev\doublehair\resources\views\layouts\sections\menu\verticalMenu.blade.php ENDPATH**/ ?>