
<?php $__env->startSection('title', 'Product Profile'); ?>

<?php $__env->startSection('content'); ?>
<div>
  <!-- Product Profile Content -->
  <div class="row">
      <div class="col-xl-4 col-lg-5 col-md-5">
          <!-- About Product -->
          <div class="card mb-4">
              <div class="card-body">
                  <div class="d-flex align-items-center justify-content-center" style="text-align: center; height: 100%;">
                      <div class="badge rounded-pill bg-label-primary">
                          <i class="menu-icon tf-icons ti ti-package" style="font-size: 72px;"></i>
                      </div>
                  </div>
                  
                  <ul class="list-unstyled mb-4 mt-3">
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-file-invoice"></i>
                          <span class="fw-bold mx-2">Product Name:</span>
                          <span><?php echo e($product->name ?? '-'); ?></span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-currency-dollar"></i>
                          <span class="fw-bold mx-2">Sale Price:</span>
                          <span class="badge bg-primary"><?php echo e(number_format($product->sale_price, 2)); ?> $</span>
                      </li>
                      <?php if($product->purchase_price): ?>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-currency-dollar"></i>
                          <span class="fw-bold mx-2">Purchase Price:</span>
                          <span class="badge bg-info"><?php echo e(number_format($product->purchase_price, 2)); ?> $</span>
                      </li>
                      <?php endif; ?>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-box"></i>
                          <span class="fw-bold mx-2">Stock Quantity:</span>
                          <span><?php echo e($product->stock_quantity ?? 0); ?></span>
                      </li>
                      <?php if($product->expired_date): ?>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-calendar"></i>
                          <span class="fw-bold mx-2">Expired Date:</span>
                          <span><?php echo e($product->expired_date->format('M d, Y')); ?></span>
                      </li>
                      <?php endif; ?>
                      <?php if($product->supplier): ?>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-truck"></i>
                          <span class="fw-bold mx-2">Supplier:</span>
                          <span><?php echo e($product->supplier->name ?? '-'); ?></span>
                      </li>
                      <?php endif; ?>
                      <?php if($product->description): ?>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-file-text"></i>
                          <span class="fw-bold mx-2">Description:</span>
                          <span><?php echo e(Str::limit($product->description, 50)); ?></span>
                      </li>
                      <?php endif; ?>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-box"></i>
                          <span class="fw-bold mx-2">Total Batches:</span>
                          <span class="badge bg-success"><?php echo e($product->batches->count()); ?></span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-receipt"></i>
                          <span class="fw-bold mx-2">Times Sold:</span>
                          <span class="badge bg-warning"><?php echo e($product->invoiceItems->count()); ?></span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-currency-dollar"></i>
                          <span class="fw-bold mx-2">Total Revenue:</span>
                          <span class="badge bg-success"><?php echo e(number_format($product->invoiceItems->sum('total_price'), 2)); ?> $</span>
                      </li>
                  </ul>

                  <div class="row d-flex justify-content-center align-items-center">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $product)): ?>
                    <div class="col-md-12 mb-2">
                      <a href="<?php echo e(route('products.edit', $product)); ?>" class="btn btn-primary w-100">
                        <i class="tf-icons ti ti-edit"></i> Edit Product
                      </a>
                    </div>
                    <?php endif; ?>
                    <div class="col-md-12 mb-2">
                      <a href="<?php echo e(route('products.index')); ?>" class="btn btn-outline-secondary w-100">
                        <i class="tf-icons ti ti-arrow-left"></i> Back to List
                      </a>
                    </div>
                  </div>
              </div>
          </div>
      </div>
      
      <div class="col-xl-8 col-lg-7 col-md-7">
          <!-- Activity Timeline -->
          <div class="col-xl-12">
              <div class="nav-align-top mb-4">
                  <div class="dropdown">
                      
                      <ul class="nav nav-pills mb-3" role="tablist">
                        <li class="nav-item">
                          <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#sales" aria-controls="sales" aria-selected="true">Sales History</button>
                        </li>
                        <li class="nav-item">
                          <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#batches" aria-controls="batches" aria-selected="false">Product Batches</button>
                        </li>
                      </ul>
                      
                  </div>
                  
                  
                  <div class="tab-content">
                    
                     <div class="tab-pane fade show active" id="sales" role="tabpanel">
                      <div class="table-responsive">
                        <table class="table">
                          <thead>
                            <tr class="border-bottom">
                              <th class="text-left text-primary">Invoice Number</th>
                              <th class="text-left text-primary">Patient</th>
                              <th class="text-left text-primary">Date</th>
                              <th class="text-left text-primary">Quantity</th>
                              <th class="text-left text-primary">Unit Price</th>
                              <th class="text-left text-primary">Total</th>
                              <th></th>
                            </tr>
                          </thead>
                          <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $invoiceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                              <td><?php echo e($item->invoice->invoice_number ?? '-'); ?></td>
                              <td><?php echo e($item->invoice->patient->name ?? '-'); ?> (<?php echo e($item->invoice->patient->code ?? '-'); ?>)</td>
                              <td><?php echo e($item->invoice->invoice_date ? $item->invoice->invoice_date->format('M d, Y') : '-'); ?></td>
                              <td><strong><?php echo e($item->quantity); ?></strong></td>
                              <td><?php echo e(number_format($item->unit_price, 2)); ?> $</td>
                              <td><strong class="text-primary"><?php echo e(number_format($item->total_price, 2)); ?> $</strong></td>
                              <td class="text-center" style="width: 134px;">
                                <div role="group" aria-label="Row Actions" class="btn-group">
                                  <a href="<?php echo e(route('invoices.show', $item->invoice)); ?>">
                                    <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                      <i class="fa fa-eye"></i>
                                    </button>
                                  </a>
                                </div>
                              </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                              <td colspan="7" class="text-center py-4">
                                <p class="text-muted">This product has not been sold yet</p>
                              </td>
                            </tr>
                            <?php endif; ?>
                          </tbody>
                        </table>
                        <br>
                        <div style="float: right" class="d-flex justify-content-start align-items-start">
                          <?php echo e($invoiceItems->links()); ?>

                        </div>
                      </div>
                     </div>

                    
                     <div class="tab-pane fade" id="batches" role="tabpanel">
                      <div class="table-responsive">
                        <table class="table">
                          <thead>
                            <tr class="border-bottom">
                              <th class="text-left text-primary">Batch Number</th>
                              <th class="text-left text-primary">Purchase Date</th>
                              <th class="text-left text-primary">Expired Date</th>
                              <th class="text-left text-primary">Quantity</th>
                              <th class="text-left text-primary">Sold</th>
                              <th class="text-left text-primary">Returned</th>
                              <th class="text-left text-primary">Available</th>
                              <th class="text-left text-primary">Purchase Price</th>
                            </tr>
                          </thead>
                          <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $product->batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                              <td><strong><?php echo e($batch->batch_number ?? '-'); ?></strong></td>
                              <td><?php echo e($batch->purchase_date ? $batch->purchase_date->format('M d, Y') : '-'); ?></td>
                              <td><?php echo e($batch->expired_date ? $batch->expired_date->format('M d, Y') : '-'); ?></td>
                              <td><?php echo e($batch->quantity); ?></td>
                              <td><span class="badge bg-warning"><?php echo e($batch->sold_quantity); ?></span></td>
                              <td><span class="badge bg-info"><?php echo e($batch->returned_quantity); ?></span></td>
                              <td><span class="badge bg-success"><?php echo e($batch->available_quantity); ?></span></td>
                              <td><?php echo e(number_format($batch->purchase_price, 2)); ?> $</td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                              <td colspan="8" class="text-center py-4">
                                <p class="text-muted">No batches found for this product</p>
                              </td>
                            </tr>
                            <?php endif; ?>
                          </tbody>
                        </table>
                      </div>
                     </div>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\app\products\show.blade.php ENDPATH**/ ?>