<div>
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="card-title mb-0">
                    <i class="menu-icon tf-icons ti ti-receipt me-2"></i>
                    Invoices
                </h4>
            </div>

            <!-- Filters -->
            <div class="card filter-card mb-4 border">
                <div class="card-header bg-white border-bottom py-3 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 text-primary">
                        <i class="menu-icon tf-icons ti ti-filter me-2"></i>
                        Filters
                    </h5>
                    <button wire:click="resetFilters" class="btn btn-outline-secondary btn-sm">
                        <i class="menu-icon tf-icons ti ti-refresh me-1"></i>
                        Reset
                    </button>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">Search</label>
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="menu-icon tf-icons ti ti-search"></i>
                                </span>
                                <input 
                                    type="text" 
                                    wire:model.live.debounce.300ms="search" 
                                    class="form-control" 
                                    placeholder="Invoice number, patient..."
                                >
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Start Date</label>
                            <input type="date" wire:model.live="startDate" class="form-control">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">End Date</label>
                            <input type="date" wire:model.live="endDate" class="form-control">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Status</label>
                            <select wire:model.live="status" class="form-select">
                                <option value="">All Status</option>
                                <option value="draft">Draft</option>
                                <option value="completed">Completed</option>
                                <option value="cancelled">Cancelled</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Patient</label>
                            <div class="position-relative" x-data="{ open: false }">
                                <div class="input-group">
                                    <input 
                                        type="text" 
                                        class="form-control" 
                                        placeholder="<?php echo e($patient_id ? 'Patient selected' : 'Search patient...'); ?>"
                                        wire:model.live.debounce.300ms="patientSearch"
                                        @focus="open = true"
                                        @click.away="setTimeout(() => open = false, 200)"
                                        <?php if($patient_id): ?> readonly style="background-color: #e9ecef;" <?php endif; ?>
                                    >
                                    <?php if($patient_id): ?>
                                        <button 
                                            class="btn btn-outline-secondary" 
                                            type="button"
                                            wire:click="clearPatient"
                                            title="Clear patient filter"
                                        >
                                            <i class="menu-icon tf-icons ti ti-x"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                                <div 
                                    class="position-absolute w-100 mt-1 bg-white border rounded shadow-lg" 
                                    x-show="open"
                                    style="max-height: 250px; overflow-y: auto; z-index: 1000;"
                                    x-cloak
                                    x-transition
                                    wire:loading.class="d-none"
                                >
                                    <?php if($filteredPatients->count() > 0): ?>
                                        <?php $__currentLoopData = $filteredPatients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <button 
                                                type="button"
                                                class="btn btn-sm btn-light w-100 text-start border-bottom rounded-0"
                                                wire:click="selectPatient(<?php echo e($patient->id); ?>)"
                                                @click="open = false"
                                            >
                                                <div>
                                                    <strong><?php echo e($patient->name); ?></strong>
                                                    <br>
                                                    <small class="text-muted"><?php echo e($patient->code); ?></small>
                                                    <?php if($patient->phone): ?>
                                                        <small class="text-muted"> • <?php echo e($patient->phone); ?></small>
                                                    <?php endif; ?>
                                                </div>
                                            </button>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <div class="p-2 text-muted text-center">
                                            <small>No patients found</small>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <label class="form-label">User</label>
                            <select wire:model.live="user_id" class="form-select">
                                <option value="">All Users</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Table -->
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th style="cursor: pointer;" wire:click="sortByField('invoice_number')">
                                Invoice #
                                <?php if($sortBy === 'invoice_number'): ?>
                                    <i class="menu-icon tf-icons ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('patient_id')">
                                Patient
                                <?php if($sortBy === 'patient_id'): ?>
                                    <i class="menu-icon tf-icons ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('invoice_date')">
                                Date
                                <?php if($sortBy === 'invoice_date'): ?>
                                    <i class="menu-icon tf-icons ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('total_amount')">
                                Total Amount
                                <?php if($sortBy === 'total_amount'): ?>
                                    <i class="menu-icon tf-icons ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('status')">
                                Status
                                <?php if($sortBy === 'status'): ?>
                                    <i class="menu-icon tf-icons ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th>Created By</th>
                            <th style="cursor: pointer;" wire:click="sortByField('created_at')">
                                Created At
                                <?php if($sortBy === 'created_at'): ?>
                                    <i class="menu-icon tf-icons ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <strong><?php echo e($invoice->invoice_number); ?></strong>
                                </td>
                                <td>
                                    <?php if($invoice->patient): ?>
                                        <div>
                                            <strong><?php echo e($invoice->patient->name); ?></strong>
                                            <br>
                                            <small class="text-muted"><?php echo e($invoice->patient->code); ?></small>
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo e($invoice->invoice_date->format('Y-m-d')); ?>

                                </td>
                                <td>
                                    <strong class="text-success"><?php echo e(number_format($invoice->total_amount, 2)); ?></strong>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($invoice->status === 'completed' ? 'success' : ($invoice->status === 'cancelled' ? 'danger' : 'warning')); ?>">
                                        <?php echo e(ucfirst($invoice->status)); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php if($invoice->user): ?>
                                        <span class="text-muted"><?php echo e($invoice->user->name); ?></span>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <small class="text-muted"><?php echo e($invoice->created_at->format('Y-m-d H:i')); ?></small>
                                </td>
                                <td class="text-center" style="width: 134px;">
                                    <div role="group" aria-label="Row Actions" class="btn-group">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $invoice)): ?>
                                        <a href="<?php echo e(route('invoices.show', $invoice)); ?>">
                                            <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $invoice)): ?>
                                        <a href="<?php echo e(route('invoices.edit', $invoice)); ?>">
                                            <button type="button" class="btn btn-icon btn-outline-info m-1">
                                                <i class="fa fa-edit"></i>
                                            </button>
                                        </a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $invoice)): ?>
                                        <button 
                                            wire:click="deleteInvoice(<?php echo e($invoice->id); ?>)"
                                            wire:confirm="Are you sure you want to delete this invoice?"
                                            type="button" 
                                            class="btn btn-icon btn-outline-danger m-1"
                                        >
                                            <i class="fa fa-trash"></i>
                                        </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="menu-icon tf-icons ti ti-receipt fs-1 d-block mb-2"></i>
                                        No invoices found
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                <?php echo e($invoices->links()); ?>

            </div>
        </div>
    </div>
</div>

<?php /**PATH C:\Dev\doublehair\resources\views\livewire\invoice-list.blade.php ENDPATH**/ ?>