<div>
  <div x-cloak x-data="{ open: false }" x-on:click.away="open = false" style="position: relative;">
      <?php if($label): ?>
      <label class="label-control"><?php echo e($label); ?></label>
      <?php endif; ?>
      <div class="input-group">
          <?php if($selectedValue == null): ?>
              <input type="text" class="<?php echo e($class); ?>" wire:model.live='search'
                  x-on:click="open = true"
                  x-on:input="open = true"
                  placeholder="<?php echo e($placeholder); ?>"
                  <?php if($options->isEmpty()): ?> disabled <?php endif; ?>
                  <?php if($disabled): ?> disabled <?php endif; ?>
              >
              <span class="input-group-text" style="cursor: pointer;" x-on:click="open = !open" <?php if($disabled): ?> disabled <?php endif; ?>>
                <i class="ti ti-caret-down"></i>
              </span>
          </div>
          <div wire:loading.remove x-show="open" class="mt-2 border bg-white shadow-lg" style="position: absolute; top: 100%; left: 0; right: 0; max-height: <?php echo e($height ?? '200px'); ?>; overflow-y: auto; z-index: 999; border-radius: 8px;">
              <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $title): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php $disabledOption = $disabledOptions->contains($id) ?>
                  <?php if(stripos($title, $search) !== false): ?>
                      <button class="<?php if($disabledOption): ?> bg-secondary <?php else: ?> bg-white <?php endif; ?> border-bottom" style="border: 0; width: 100%; text-align: left;" wire:click="selectValue('<?php echo e($id); ?>')" <?php if($disabledOption): ?> disabled <?php endif; ?>>
                          <h6 class="<?php if($disabledOption): ?> text-white <?php endif; ?> mx-2 mt-1"><?php echo e($title); ?></h6>
                      </button>
                  <?php endif; ?>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
          <?php else: ?>
          <div class="input-group">
              <input type="text" class="<?php echo e($class); ?>" x-on:click="open = false" value="<?php echo e($options[$selectedValue]); ?>" disabled>
              <?php if(!$disabled): ?>
              <button class="<?php echo e($btnclass); ?>" wire:click="selectValue(null)">X</button>
              <?php endif; ?>
          </div>
          <?php endif; ?>
      </div>
  </div>
<?php /**PATH C:\Dev\doublehair\resources\views\livewire\components\custom-select.blade.php ENDPATH**/ ?>