<?php $__env->startSection('title', 'Users'); ?>

<?php $__env->startSection('content'); ?>
    <?php if(session()->has('errors') && session('errors')->has('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="ti ti-alert-circle me-2"></i>
            <?php echo e(session('errors')->first('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="ti ti-check me-2"></i>
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <div class="searchbar mt-0 mb-4">
        <div class="row">
            <div class="col-md-6">
                <form>
                    <div class="input-group">
                        <input
                            required
                            id="indexSearch"
                            type="text"
                            name="search"
                            placeholder="<?php echo e(__('crud.common.search')); ?>"
                            value="<?php echo e($search ?? ''); ?>"
                            class="form-control"
                            autocomplete="off"
                        />
                        <div class="input-group-append">
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-md-6 text-right">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
                <a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary">
                    <i class="icon ion-md-add"></i> <?php echo app('translator')->get('crud.common.create'); ?>
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div style="display: flex; justify-content: space-between;">
                <h4 class="card-title"><?php echo app('translator')->get('crud.users.index_title'); ?></h4>
            </div>
            <?php if(session()->get('message')): ?>
                <div class="alert <?php echo e(session()->get('message')['type']); ?> alert-dismissible fade show" role="alert">
                    <div class="alert-body">
                        <?php echo e(session()->get('message')['message']); ?>

                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <div class="table-responsive">
                <table class="table table-borderless table-hover" id="table_id">
                    <thead>
                        <tr>
                            <th class="text-left">
                                <?php echo app('translator')->get('crud.users.inputs.name'); ?>
                            </th>
                            <th class="text-left">
                                <?php echo app('translator')->get('crud.users.inputs.email'); ?>
                            </th>
                            <th class="text-left">
                               <?php echo app('translator')->get('word.Role'); ?>
                            </th>
                            <th class="text-center">
                                <?php echo app('translator')->get('crud.common.actions'); ?>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($user->name ?? '-'); ?></td>
                            <td><?php echo e($user->email ?? '-'); ?></td>
                            <td>
                                <?php if($user->roles->isNotEmpty()): ?>
                                    <?php echo e($user->roles->pluck('name')->join(', ')); ?>

                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td class="text-center" style="width: 134px;">
                                <div
                                    role="group"
                                    aria-label="Row Actions"
                                    class="btn-group"
                                >
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $user)): ?>
                                    <a href="<?php echo e(route('users.edit', $user)); ?>">
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-primary"
                                            title="Update"
                                            type="submit"
                                            class="
                                                btn btn-icon btn-outline-primary
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-edit"></i>
                                        </button>
                                    </a>
                                    <?php endif; ?> <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $user)): ?>
                                    <a href="<?php echo e(route('users.show', $user)); ?>">
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-info"
                                            title="View"
                                            type="button"
                                            class="
                                                btn btn-icon btn-outline-info
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-eye"></i>
                                        </button>
                                    </a>
                                    <?php endif; ?> <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $user)): ?>
                                    <form
                                        action="<?php echo e(route('users.destroy', $user)); ?>"
                                        method="POST"
                                        onsubmit="return confirm('<?php echo e(__('crud.common.are_you_sure')); ?>')"
                                    >
                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-danger"
                                            title="Delete"
                                            type="submit"
                                            class="
                                                btn btn-icon btn-outline-danger
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </form>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="3">
                                <?php echo app('translator')->get('crud.common.no_items_found'); ?>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="3"><?php echo $users->render(); ?></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\app\users\index.blade.php ENDPATH**/ ?>