<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Home'); ?>

<?php $__env->startSection('vendor-style'); ?>
<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php if(Auth::user()->hasRole('super-admin') || Auth::user()->hasRole('supervisor')): ?>
<!-- Welcome Card -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card bg-primary text-white" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="fw-bold mb-0 text-white"><?php echo app('translator')->get('word.Welcome'); ?> <?php echo e(Auth::user()->name); ?></h4>
                        <p class="mb-0 text-white-50">Patient Management System Dashboard</p>
                    </div>
                    <div>
                        <i class="menu-icon tf-icons ti ti-dashboard fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Revenue Stats Cards -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0" style="border-left: 4px solid #667eea;">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted mb-2">Total Revenue</h6>
                        <h3 class="mb-0 fw-bold text-primary"><?php echo e(number_format($totalRevenue ?? 0, 2)); ?></h3>
                        <small class="text-muted">All Time</small>
                    </div>
                    <div class="rounded-circle bg-primary-light p-3">
                        <i class="menu-icon tf-icons ti ti-currency-dollar fs-2 text-primary"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0" style="border-left: 4px solid #10b981;">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted mb-2">This Month</h6>
                        <h3 class="mb-0 fw-bold text-success"><?php echo e(number_format($monthRevenue ?? 0, 2)); ?></h3>
                        <?php if(isset($revenueGrowth)): ?>
                            <small class="text-<?php echo e($revenueGrowth >= 0 ? 'success' : 'danger'); ?>">
                                <i class="ti ti-arrow-<?php echo e($revenueGrowth >= 0 ? 'up' : 'down'); ?>"></i>
                                <?php echo e(number_format(abs($revenueGrowth), 1)); ?>%
                            </small>
                        <?php endif; ?>
                    </div>
                    <div class="rounded-circle bg-success-light p-3">
                        <i class="menu-icon tf-icons ti ti-calendar-stats fs-2 text-success"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0" style="border-left: 4px solid #f59e0b;">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted mb-2">Today's Revenue</h6>
                        <h3 class="mb-0 fw-bold text-warning"><?php echo e(number_format($todayRevenue ?? 0, 2)); ?></h3>
                        <small class="text-muted"><?php echo e($invoicesToday ?? 0); ?> invoices</small>
                    </div>
                    <div class="rounded-circle bg-warning-light p-3">
                        <i class="menu-icon tf-icons ti ti-calendar-event fs-2 text-warning"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0" style="border-left: 4px solid #ef4444;">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted mb-2">Avg Invoice</h6>
                        <h3 class="mb-0 fw-bold text-danger">
                            <?php echo e($totalInvoices > 0 ? number_format(($totalRevenue ?? 0) / $totalInvoices, 2) : '0.00'); ?>

                        </h3>
                        <small class="text-muted">Per invoice</small>
                    </div>
                    <div class="rounded-circle bg-danger-light p-3">
                        <i class="menu-icon tf-icons ti ti-chart-bar fs-2 text-danger"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Stats Cards -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-body text-center">
                <div class="rounded-circle bg-primary-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-users fs-2 text-primary"></i>
                </div>
                <h3 class="mb-0 fw-bold"><?php echo e($totalPatients ?? 0); ?></h3>
                <p class="text-muted mb-2">Total Patients</p>
                <small class="text-success">
                    <i class="ti ti-arrow-up"></i> <?php echo e($newPatientsThisMonth ?? 0); ?> this month
                </small>
                <div class="mt-3">
                    <a href="<?php echo e(route('patients.index')); ?>" class="btn btn-sm btn-primary">
                        <i class="ti ti-eye me-1"></i> View All
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-body text-center">
                <div class="rounded-circle bg-success-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-receipt fs-2 text-success"></i>
                </div>
                <h3 class="mb-0 fw-bold"><?php echo e($totalInvoices ?? 0); ?></h3>
                <p class="text-muted mb-2">Total Invoices</p>
                <small class="text-info">
                    <i class="ti ti-calendar"></i> <?php echo e($invoicesThisMonth ?? 0); ?> this month
                </small>
                <div class="mt-3">
                    <a href="<?php echo e(route('invoices.index')); ?>" class="btn btn-sm btn-success">
                        <i class="ti ti-eye me-1"></i> View All
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-body text-center">
                <div class="rounded-circle bg-info-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-package fs-2 text-info"></i>
                </div>
                <h3 class="mb-0 fw-bold"><?php echo e($totalProducts ?? 0); ?></h3>
                <p class="text-muted mb-2">Total Products</p>
                <small class="text-warning">
                    <?php if(isset($lowStockProducts) && $lowStockProducts > 0): ?>
                        <i class="ti ti-alert-triangle"></i> <?php echo e($lowStockProducts); ?> low stock
                    <?php else: ?>
                        <i class="ti ti-check"></i> Stock OK
                    <?php endif; ?>
                </small>
                <div class="mt-3">
                    <a href="<?php echo e(route('products.index')); ?>" class="btn btn-sm btn-info text-white">
                        <i class="ti ti-eye me-1"></i> View All
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-body text-center">
                <div class="rounded-circle bg-warning-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-alert-triangle fs-2 text-warning"></i>
                </div>
                <h3 class="mb-0 fw-bold"><?php echo e(($lowStockProducts ?? 0) + ($outOfStockProducts ?? 0)); ?></h3>
                <p class="text-muted mb-2">Stock Alerts</p>
                <small class="text-danger">
                    <i class="ti ti-x"></i> <?php echo e($outOfStockProducts ?? 0); ?> out of stock
                </small>
                <div class="mt-3">
                    <a href="<?php echo e(route('products.index')); ?>" class="btn btn-sm btn-warning">
                        <i class="ti ti-eye me-1"></i> View Products
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row mb-4">
    <!-- Monthly Revenue Chart -->
    <div class="col-lg-8 col-md-12 mb-3">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <h5 class="mb-0">
                    <i class="menu-icon tf-icons ti ti-chart-line me-2 text-primary"></i>
                    Monthly Revenue Trend (Last 6 Months)
                </h5>
            </div>
            <div class="card-body">
                <canvas id="monthlyRevenueChart" height="100"></canvas>
            </div>
        </div>
    </div>
    
    <!-- Invoice Status Pie Chart -->
    <div class="col-lg-4 col-md-12 mb-3">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <h5 class="mb-0">
                    <i class="menu-icon tf-icons ti ti-chart-pie me-2 text-info"></i>
                    Invoice Status
                </h5>
            </div>
            <div class="card-body">
                <canvas id="invoiceStatusChart" height="200"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Daily Revenue & Monthly Invoices -->
<div class="row mb-4">
    <!-- Daily Revenue Chart -->
    <div class="col-lg-6 col-md-12 mb-3">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <h5 class="mb-0">
                    <i class="menu-icon tf-icons ti ti-chart-bar me-2 text-success"></i>
                    Daily Revenue (Last 7 Days)
                </h5>
            </div>
            <div class="card-body">
                <canvas id="dailyRevenueChart" height="100"></canvas>
            </div>
        </div>
    </div>
    
    <!-- Monthly Invoices Chart -->
    <div class="col-lg-6 col-md-12 mb-3">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <h5 class="mb-0">
                    <i class="menu-icon tf-icons ti ti-chart-area me-2 text-warning"></i>
                    Monthly Invoices (Last 6 Months)
                </h5>
            </div>
            <div class="card-body">
                <canvas id="monthlyInvoicesChart" height="100"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Top Products & Top Patients -->
<div class="row mb-4">
    <!-- Top Products -->
    <div class="col-lg-6 col-md-12 mb-3">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="menu-icon tf-icons ti ti-package me-2 text-info"></i>
                        Top Products
                    </h5>
                    <a href="<?php echo e(route('products.index')); ?>" class="btn btn-sm btn-outline-info">View All</a>
                </div>
            </div>
            <div class="card-body">
                <?php if(isset($topProducts) && $topProducts->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th class="text-end">Sold</th>
                                    <th class="text-end">Stock</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $topProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong><?php echo e($product->name); ?></strong>
                                        <br>
                                        <small class="text-muted"><?php echo e(number_format($product->sale_price, 2)); ?> each</small>
                                    </td>
                                    <td class="text-end">
                                        <span class="badge bg-success"><?php echo e($product->total_sold ?? 0); ?></span>
                                    </td>
                                    <td class="text-end">
                                        <?php if($product->stock_quantity > 10): ?>
                                            <span class="badge bg-success"><?php echo e($product->stock_quantity); ?></span>
                                        <?php elseif($product->stock_quantity > 0): ?>
                                            <span class="badge bg-warning"><?php echo e($product->stock_quantity); ?></span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">0</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center mb-0">No product sales data available</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Top Patients -->
    <div class="col-lg-6 col-md-12 mb-3">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="menu-icon tf-icons ti ti-users me-2 text-primary"></i>
                        Top Patients
                    </h5>
                    <a href="<?php echo e(route('patients.index')); ?>" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
            </div>
            <div class="card-body">
                <?php if(isset($topPatients) && $topPatients->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover">
                            <thead>
                                <tr>
                                    <th>Patient</th>
                                    <th class="text-end">Invoices</th>
                                    <th>Code</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $topPatients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong><?php echo e($patient->name); ?></strong>
                                        <br>
                                        <small class="text-muted"><?php echo e($patient->phone ?? '-'); ?></small>
                                    </td>
                                    <td class="text-end">
                                        <span class="badge bg-primary"><?php echo e($patient->invoices_count); ?></span>
                                    </td>
                                    <td>
                                        <code><?php echo e($patient->code); ?></code>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center mb-0">No patient data available</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm hover-card" onclick="window.location.href = '<?php echo e(route('patients.create')); ?>'">
            <div class="card-body text-center">
                <div class="rounded-circle bg-primary-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-user-plus fs-2 text-primary"></i>
                </div>
                <h5 class="card-title">New Patient</h5>
                <p class="card-text small text-muted">Add a new patient</p>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm hover-card" onclick="window.location.href = '<?php echo e(route('invoices.create')); ?>'">
            <div class="card-body text-center">
                <div class="rounded-circle bg-success-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-file-plus fs-2 text-success"></i>
                </div>
                <h5 class="card-title">New Invoice</h5>
                <p class="card-text small text-muted">Create a new invoice</p>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm hover-card" onclick="window.location.href = '<?php echo e(route('products.create')); ?>'">
            <div class="card-body text-center">
                <div class="rounded-circle bg-info-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-package fs-2 text-info"></i>
                </div>
                <h5 class="card-title">New Product</h5>
                <p class="card-text small text-muted">Add a new product</p>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm hover-card" onclick="window.location.href = '<?php echo e(route('reports.invoices')); ?>'">
            <div class="card-body text-center">
                <div class="rounded-circle bg-warning-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-chart-line fs-2 text-warning"></i>
                </div>
                <h5 class="card-title">View Reports</h5>
                <p class="card-text small text-muted">Analytics & Reports</p>
            </div>
        </div>
    </div>
</div>

<!-- Recent Invoices -->
<?php if(isset($recentInvoices) && $recentInvoices->count() > 0): ?>
<div class="row">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="menu-icon tf-icons ti ti-receipt me-2 text-primary"></i>
                        Recent Invoices
                    </h5>
                    <a href="<?php echo e(route('invoices.index')); ?>" class="btn btn-sm btn-primary">View All</a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Invoice #</th>
                                <th>Patient</th>
                                <th>Date</th>
                                <th>Total</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $recentInvoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($invoice->invoice_number); ?></strong></td>
                                <td><?php echo e($invoice->patient->name ?? '-'); ?> <small class="text-muted">(<?php echo e($invoice->patient->code ?? '-'); ?>)</small></td>
                                <td><?php echo e($invoice->invoice_date->format('Y-m-d')); ?></td>
                                <td><strong><?php echo e(number_format($invoice->total_amount, 2)); ?></strong></td>
                                <td>
                                    <span class="badge bg-<?php echo e($invoice->status === 'completed' ? 'success' : ($invoice->status === 'cancelled' ? 'danger' : 'warning')); ?>">
                                        <?php echo e(ucfirst($invoice->status)); ?>

                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('invoices.show', $invoice->id)); ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="ti ti-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php elseif(Auth::user()->hasRole('cashier')): ?>
<!-- Cashier Dashboard -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card bg-primary text-white" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="fw-bold mb-0 text-white"><?php echo app('translator')->get('word.Welcome'); ?> <?php echo e(Auth::user()->name); ?> ! 👋</h4>
                        <p class="mb-0 text-white-50">Cashier Dashboard</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-lg-6 col-md-12 mb-3">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-body text-center">
                <div class="rounded-circle bg-primary-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-receipt fs-2 text-primary"></i>
                </div>
                <h3 class="mb-0 fw-bold"><?php echo e($totalInvoices ?? 0); ?></h3>
                <p class="text-muted mb-0">Total Invoices</p>
            </div>
        </div>
    </div>
    
    <div class="col-lg-6 col-md-12 mb-3">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-body text-center">
                <div class="rounded-circle bg-success-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-calendar fs-2 text-success"></i>
                </div>
                <h3 class="mb-0 fw-bold"><?php echo e($invoicesToday ?? 0); ?></h3>
                <p class="text-muted mb-0">Invoices Today</p>
            </div>
        </div>
    </div>
</div>

<?php if(isset($recentInvoices) && $recentInvoices->count() > 0): ?>
<div class="row">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <h5 class="mb-0">
                    <i class="menu-icon tf-icons ti ti-receipt me-2 text-primary"></i>
                    My Recent Invoices
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Invoice #</th>
                                <th>Patient</th>
                                <th>Date</th>
                                <th>Total</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $recentInvoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($invoice->invoice_number); ?></strong></td>
                                <td><?php echo e($invoice->patient->name ?? '-'); ?></td>
                                <td><?php echo e($invoice->invoice_date->format('Y-m-d')); ?></td>
                                <td><strong><?php echo e(number_format($invoice->total_amount, 2)); ?></strong></td>
                                <td>
                                    <span class="badge bg-<?php echo e($invoice->status === 'completed' ? 'success' : ($invoice->status === 'cancelled' ? 'danger' : 'warning')); ?>">
                                        <?php echo e(ucfirst($invoice->status)); ?>

                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('invoices.show', $invoice->id)); ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="ti ti-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php else: ?>
<!-- Default/Other Roles -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body text-center">
                <h4 class="mb-0"><?php echo app('translator')->get('word.Welcome'); ?> <?php echo e(Auth::user()->name); ?> ! 👋</h4>
                <p class="text-muted">Patient Management System</p>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- CSS for hover effects -->
<style>
    .hover-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        cursor: pointer;
    }
    
    .hover-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1) !important;
    }
    
    .bg-primary-light {
        background-color: rgba(79, 70, 229, 0.1);
    }
    
    .bg-success-light {
        background-color: rgba(40, 167, 69, 0.1);
    }
    
    .bg-info-light {
        background-color: rgba(23, 162, 184, 0.1);
    }
    
    .bg-warning-light {
        background-color: rgba(255, 193, 7, 0.1);
    }
    
    .bg-danger-light {
        background-color: rgba(239, 68, 68, 0.1);
    }
    
    .card {
        border-radius: 12px;
    }
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<?php if(Auth::user()->hasRole('super-admin') || Auth::user()->hasRole('supervisor')): ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Monthly Revenue Chart
    const monthlyRevenueCtx = document.getElementById('monthlyRevenueChart');
    if (monthlyRevenueCtx) {
        const monthlyRevenueData = <?php echo json_encode($monthlyRevenue ?? [], 15, 512) ?>;
        new Chart(monthlyRevenueCtx, {
            type: 'line',
            data: {
                labels: monthlyRevenueData.map(item => item.month),
                datasets: [{
                    label: 'Revenue',
                    data: monthlyRevenueData.map(item => item.revenue),
                    borderColor: 'rgb(102, 126, 234)',
                    backgroundColor: 'rgba(102, 126, 234, 0.1)',
                    tension: 0.4,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return value.toLocaleString();
                            }
                        }
                    }
                }
            }
        });
    }

    // Invoice Status Pie Chart
    const invoiceStatusCtx = document.getElementById('invoiceStatusChart');
    if (invoiceStatusCtx) {
        const invoicesByStatus = <?php echo json_encode($invoicesByStatus ?? [], 15, 512) ?>;
        const statusData = {
            labels: invoicesByStatus.map(item => item.status.charAt(0).toUpperCase() + item.status.slice(1)),
            datasets: [{
                data: invoicesByStatus.map(item => item.total),
                backgroundColor: [
                    'rgba(40, 167, 69, 0.8)',   // success - green
                    'rgba(255, 193, 7, 0.8)',    // warning - yellow
                    'rgba(239, 68, 68, 0.8)'     // danger - red
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        };
        
        new Chart(invoiceStatusCtx, {
            type: 'doughnut',
            data: statusData,
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        position: 'bottom'
                    }
                }
            }
        });
    }

    // Daily Revenue Chart
    const dailyRevenueCtx = document.getElementById('dailyRevenueChart');
    if (dailyRevenueCtx) {
        const dailyRevenueData = <?php echo json_encode($dailyRevenue ?? [], 15, 512) ?>;
        new Chart(dailyRevenueCtx, {
            type: 'bar',
            data: {
                labels: dailyRevenueData.map(item => item.day),
                datasets: [{
                    label: 'Revenue',
                    data: dailyRevenueData.map(item => item.revenue),
                    backgroundColor: 'rgba(40, 167, 69, 0.8)',
                    borderColor: 'rgb(40, 167, 69)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return value.toLocaleString();
                            }
                        }
                    }
                }
            }
        });
    }

    // Monthly Invoices Chart
    const monthlyInvoicesCtx = document.getElementById('monthlyInvoicesChart');
    if (monthlyInvoicesCtx) {
        const monthlyInvoicesData = <?php echo json_encode($monthlyInvoices ?? [], 15, 512) ?>;
        new Chart(monthlyInvoicesCtx, {
            type: 'bar',
            data: {
                labels: monthlyInvoicesData.map(item => item.month),
                datasets: [{
                    label: 'Invoices',
                    data: monthlyInvoicesData.map(item => item.count),
                    backgroundColor: 'rgba(255, 193, 7, 0.8)',
                    borderColor: 'rgb(255, 193, 7)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                }
            }
        });
    }
});
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\content\pages\pages-home.blade.php ENDPATH**/ ?>