
<?php $__env->startSection('title', 'Clinics'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="card-title mb-0">Clinics</h4>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Clinic::class)): ?>
                <a href="<?php echo e(route('clinics.create')); ?>" class="btn btn-primary">
                    <i class="icon ion-md-add"></i> Create Clinic
                </a>
                <?php endif; ?>
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>Email</th>
                            <th>Address</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $clinics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clinic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($clinic->name); ?></td>
                                <td><?php echo e($clinic->phone ?? '-'); ?></td>
                                <td><?php echo e($clinic->email ?? '-'); ?></td>
                                <td><?php echo e($clinic->address ?? '-'); ?></td>
                                <td>
                                    <div role="group" class="btn-group">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $clinic)): ?>
                                        <a href="<?php echo e(route('clinics.show', $clinic)); ?>" class="btn btn-sm btn-outline-primary">
                                            <i class="icon ion-md-eye"></i>
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $clinic)): ?>
                                        <a href="<?php echo e(route('clinics.edit', $clinic)); ?>" class="btn btn-sm btn-outline-info">
                                            <i class="icon ion-md-create"></i>
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $clinic)): ?>
                                        <form action="<?php echo e(route('clinics.destroy', $clinic)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure?')">
                                                <i class="icon ion-md-trash"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center">No clinics found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                <?php echo e($clinics->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\app\clinics\index.blade.php ENDPATH**/ ?>