
<?php $__env->startSection('title', 'Subcategories'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="card-title mb-0">Subcategories</h4>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Subcategory::class)): ?>
                <a href="<?php echo e(route('subcategories.create')); ?>" class="btn btn-primary">
                    <i class="icon ion-md-add"></i> Create Subcategory
                </a>
                <?php endif; ?>
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Category</th>
                            <th>Cost</th>
                            <th>Description</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($subcategory->name); ?></td>
                                <td><?php echo e($subcategory->category->name ?? '-'); ?></td>
                                <td><?php echo e(number_format($subcategory->cost, 2)); ?></td>
                                <td><?php echo e(Str::limit($subcategory->description, 50) ?? '-'); ?></td>
                                <td class="text-center" style="width: 134px;">
                                    <div role="group" aria-label="Row Actions" class="btn-group">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $subcategory)): ?>
                                        <a href="<?php echo e(route('subcategories.show', $subcategory)); ?>">
                                            <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $subcategory)): ?>
                                        <a href="<?php echo e(route('subcategories.edit', $subcategory)); ?>">
                                            <button type="button" class="btn btn-icon btn-outline-info m-1">
                                                <i class="fa fa-edit"></i>
                                            </button>
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $subcategory)): ?>
                                        <form action="<?php echo e(route('subcategories.destroy', $subcategory)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-icon btn-outline-danger m-1" onclick="return confirm('Are you sure?')">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center">No subcategories found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                <?php echo e($subcategories->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\app\subcategories\index.blade.php ENDPATH**/ ?>