<?php $__env->startSection('title', 'System Logs'); ?>

<?php $__env->startSection('page-style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/pages/page-icons.css')); ?>" />
<style>
    .filter-card {
        background: #f8f9fa;
        border-radius: 8px;
        padding: 20px;
        margin-bottom: 20px;
    }
    .quick-filter-btn {
        margin: 5px;
    }
    .log-row {
        transition: all 0.2s ease;
    }
    .log-row:hover {
        background-color: #f5f5f5;
        cursor: pointer;
    }
    .badge-custom {
        font-size: 0.75rem;
        padding: 0.35rem 0.65rem;
    }
    .properties-section {
        background: #f8f9fa;
        padding: 10px;
        border-radius: 5px;
        font-size: 0.85rem;
    }
    .properties-section ul {
        margin-bottom: 0;
        padding-left: 20px;
    }
    .filter-badge {
        display: inline-flex;
        align-items: center;
        margin: 5px;
    }
    .clear-filter {
        margin-left: 5px;
        cursor: pointer;
    }
    .stats-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 20px;
    }
    .stats-item {
        text-align: center;
    }
    .stats-number {
        font-size: 2rem;
        font-weight: bold;
    }
    .stats-label {
        font-size: 0.9rem;
        opacity: 0.9;
    }
    .collapsible-properties {
        max-height: 150px;
        overflow-y: auto;
        transition: max-height 0.3s ease;
    }
    .expand-btn {
        cursor: pointer;
        color: #007bff;
        font-size: 0.85rem;
        margin-top: 5px;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/select2/select2.css')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
<script src="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/select2/select2.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2').select2({
        theme: 'bootstrap-5',
        width: '100%'
    });

    // Toggle properties visibility
    $('.expand-properties').click(function() {
        const propertiesDiv = $(this).siblings('.collapsible-properties');
        propertiesDiv.toggleClass('expanded');
        if (propertiesDiv.hasClass('expanded')) {
            propertiesDiv.css('max-height', 'none');
            $(this).text('Show Less');
        } else {
            propertiesDiv.css('max-height', '150px');
            $(this).text('Show More');
        }
    });

    // Auto-submit on filter change
    $('.auto-submit').change(function() {
        $('#filterForm').submit();
    });

    // Clear individual filter
    $('.clear-filter').click(function() {
        const filterName = $(this).data('filter');
        $(`[name="${filterName}"]`).val('').trigger('change');
        $('#filterForm').submit();
    });

    // Clear all filters
    $('#clearAllFilters').click(function() {
        window.location.href = '<?php echo e(route('logs.index')); ?>';
    });

    // Export functionality
    $('#exportLogs').click(function() {
        const currentUrl = new URL(window.location.href);
        const exportUrl = '<?php echo e(route('logs.export')); ?>' + currentUrl.search;
        window.location.href = exportUrl;
    });

    // Live search with debounce
    let searchTimeout;
    $('#searchInput').on('keyup', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(function() {
            $('#filterForm').submit();
        }, 500);
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <div class="alert-body">
                    <?php echo e(session('success')); ?>

                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="stats-card">
                <div class="row">
                    <div class="col-md-3 stats-item">
                        <div class="stats-number"><?php echo e($activities->total()); ?></div>
                        <div class="stats-label">Total Logs</div>
                    </div>
                    <div class="col-md-3 stats-item">
                        <div class="stats-number">
                            <?php echo e(\Spatie\Activitylog\Models\Activity::whereDate('created_at', today())->count()); ?>

                        </div>
                        <div class="stats-label">Today's Logs</div>
                    </div>
                    <div class="col-md-3 stats-item">
                        <div class="stats-number">
                            <?php echo e(\Spatie\Activitylog\Models\Activity::where('event', 'created')->whereDate('created_at', '>=', now()->subDays(7))->count()); ?>

                        </div>
                        <div class="stats-label">Created (7 Days)</div>
                    </div>
                    <div class="col-md-3 stats-item">
                        <div class="stats-number">
                            <?php echo e(\Spatie\Activitylog\Models\Activity::where('event', 'deleted')->whereDate('created_at', '>=', now()->subDays(7))->count()); ?>

                        </div>
                        <div class="stats-label">Deleted (7 Days)</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4 class="card-title mb-0">
                <i class="ti ti-file-analytics me-2"></i><?php echo app('translator')->get('word.SystemLogs'); ?>
            </h4>
            <div>
                <button class="btn btn-sm btn-outline-danger" id="clearAllFilters" type="button">
                    <i class="ti ti-filter-off me-1"></i>Clear All Filters
                </button>
                <button class="btn btn-sm btn-success" id="exportLogs" type="button">
                    <i class="ti ti-download me-1"></i>Export CSV
                </button>
            </div>
        </div>

        <div class="card-body">
            <!-- Active Filters Display -->
            <?php if($search || $event || $user_id || $subject_type || $date_filter || isset($startDate)): ?>
            <div class="mb-3">
                <strong>Active Filters:</strong>
                <?php if($search): ?>
                    <span class="badge bg-info filter-badge">
                        Search: <?php echo e($search); ?>

                        <span class="clear-filter" data-filter="search">×</span>
                    </span>
                <?php endif; ?>
                <?php if($event): ?>
                    <span class="badge bg-warning filter-badge">
                        Event: <?php echo e($event == 'created' ? 'Created' : ($event == 'updated' ? 'Updated' : 'Deleted')); ?>

                        <span class="clear-filter" data-filter="event">×</span>
                    </span>
                <?php endif; ?>
                <?php if($user_id): ?>
                    <span class="badge bg-primary filter-badge">
                        User: <?php echo e($users->find($user_id)->name ?? 'Not Found'); ?>

                        <span class="clear-filter" data-filter="user_id">×</span>
                    </span>
                <?php endif; ?>
                <?php if($subject_type): ?>
                    <span class="badge bg-secondary filter-badge">
                        Type: <?php echo e($subject_type); ?>

                        <span class="clear-filter" data-filter="subject_type">×</span>
                    </span>
                <?php endif; ?>
                <?php if($date_filter): ?>
                    <span class="badge bg-success filter-badge">
                        Date: <?php echo e($date_filter == 'today' ? 'Today' : 
                            ($date_filter == 'yesterday' ? 'Yesterday' : 
                            ($date_filter == 'last_7_days' ? 'Last 7 Days' : 
                            ($date_filter == 'last_30_days' ? 'Last 30 Days' : 
                            ($date_filter == 'this_month' ? 'This Month' : 'Last Month'))))); ?>

                        <span class="clear-filter" data-filter="date_filter">×</span>
                    </span>
                <?php endif; ?>
                <?php if(isset($startDate)): ?>
                    <span class="badge bg-success filter-badge">
                        Date Range: <?php echo e($startDate); ?> to <?php echo e($endDate ?? ''); ?>

                    </span>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <!-- Filter Section -->
            <div class="filter-card">
                <form action="<?php echo e(route('logs.index')); ?>" method="GET" id="filterForm">
                    <!-- Quick Date Filters -->
                    <div class="row mb-3">
                        <div class="col-12">
                            <label class="form-label fw-bold">Quick Date Filter:</label>
                            <div class="btn-group" role="group">
                                <input type="radio" class="btn-check auto-submit" name="date_filter" value="today" id="today" <?php echo e($date_filter == 'today' ? 'checked' : ''); ?>>
                                <label class="btn btn-outline-primary btn-sm" for="today">Today</label>

                                <input type="radio" class="btn-check auto-submit" name="date_filter" value="yesterday" id="yesterday" <?php echo e($date_filter == 'yesterday' ? 'checked' : ''); ?>>
                                <label class="btn btn-outline-primary btn-sm" for="yesterday">Yesterday</label>

                                <input type="radio" class="btn-check auto-submit" name="date_filter" value="last_7_days" id="last_7_days" <?php echo e($date_filter == 'last_7_days' ? 'checked' : ''); ?>>
                                <label class="btn btn-outline-primary btn-sm" for="last_7_days">Last 7 Days</label>

                                <input type="radio" class="btn-check auto-submit" name="date_filter" value="last_30_days" id="last_30_days" <?php echo e($date_filter == 'last_30_days' ? 'checked' : ''); ?>>
                                <label class="btn btn-outline-primary btn-sm" for="last_30_days">Last 30 Days</label>

                                <input type="radio" class="btn-check auto-submit" name="date_filter" value="this_month" id="this_month" <?php echo e($date_filter == 'this_month' ? 'checked' : ''); ?>>
                                <label class="btn btn-outline-primary btn-sm" for="this_month">This Month</label>

                                <input type="radio" class="btn-check auto-submit" name="date_filter" value="last_month" id="last_month" <?php echo e($date_filter == 'last_month' ? 'checked' : ''); ?>>
                                <label class="btn btn-outline-primary btn-sm" for="last_month">Last Month</label>
                            </div>
                        </div>
                    </div>

                    <!-- Advanced Filters -->
                    <div class="row">
                        <div class="col-md-3">
                            <label for="searchInput" class="form-label">Search</label>
                            <input type="text" class="form-control" id="searchInput" name="search" 
                                   value="<?php echo e($search ?? ''); ?>" 
                                   placeholder="Search in logs...">
                        </div>

                        <div class="col-md-2">
                            <label for="event" class="form-label">Event Type</label>
                            <select name="event" id="event" class="form-select auto-submit">
                                <option value="">All Events</option>
                                <option value="created" <?php echo e($event == 'created' ? 'selected' : ''); ?>>Created</option>
                                <option value="updated" <?php echo e($event == 'updated' ? 'selected' : ''); ?>>Updated</option>
                                <option value="deleted" <?php echo e($event == 'deleted' ? 'selected' : ''); ?>>Deleted</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label for="user_id" class="form-label">User</label>
                            <select name="user_id" id="user_id" class="form-select select2 auto-submit">
                                <option value="">All Users</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>" <?php echo e($user_id == $user->id ? 'selected' : ''); ?>>
                                        <?php echo e($user->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label for="subject_type" class="form-label">Model Type</label>
                            <select name="subject_type" id="subject_type" class="form-select select2 auto-submit">
                                <option value="">All Types</option>
                                <?php $__currentLoopData = $modelTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($type); ?>" <?php echo e($subject_type == $type ? 'selected' : ''); ?>>
                                        <?php echo e($type); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label for="per_page" class="form-label">Per Page</label>
                            <select name="per_page" id="per_page" class="form-select auto-submit">
                                <option value="25" <?php echo e($per_page == 25 ? 'selected' : ''); ?>>25</option>
                                <option value="50" <?php echo e($per_page == 50 ? 'selected' : ''); ?>>50</option>
                                <option value="100" <?php echo e($per_page == 100 ? 'selected' : ''); ?>>100</option>
                                <option value="200" <?php echo e($per_page == 200 ? 'selected' : ''); ?>>200</option>
                            </select>
                        </div>
                    </div>
                </form>

                <!-- Custom Date Range Form -->
                <form action="<?php echo e(route('logs.search')); ?>" method="POST" class="mt-3">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="start_date" class="form-label">Date Range - From:</label>
                            <input class="form-control" type="date" value="<?php echo e($startDate ?? ''); ?>" 
                                   id="start_date" name="start_date">
                        </div>
                        <div class="col-md-4">
                            <label for="end_date" class="form-label">To:</label>
                            <input class="form-control" type="date" value="<?php echo e($endDate ?? ''); ?>" 
                                   id="end_date" name="end_date">
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <button class="btn btn-primary w-100" type="submit">
                                <i class="ti ti-search me-1"></i>Search
                            </button>
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <a href="<?php echo e(route('logs.index')); ?>" class="btn btn-outline-secondary w-100">
                                <i class="ti ti-refresh me-1"></i>Reset
                            </a>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Results Info -->
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    Showing <strong><?php echo e($activities->firstItem()); ?></strong> to 
                    <strong><?php echo e($activities->lastItem()); ?></strong> of 
                    <strong><?php echo e($activities->total()); ?></strong> results
                </div>
            </div>

            <!-- Logs Table -->
            <div class="table-responsive">
                <table class="table table-hover" id="logsTable">
                    <thead class="table-light">
                        <tr>
                            <th style="width: 60px;">#</th>
                            <th style="width: 120px;">Type</th>
                            <th style="width: 100px;">Event</th>
                            <th>Description</th>
                            <th style="width: 35%;">Properties</th>
                            <th style="width: 120px;">User</th>
                            <th style="width: 150px;">Date & Time</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="log-row">
                                <td>
                                    <span class="badge bg-label-secondary"><?php echo e($activity->id); ?></span>
                                </td>
                                <td>
                                    <span class="badge bg-label-info">
                                        <?php echo e(substr($activity->subject_type, strrpos($activity->subject_type, "\\") + 1)); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php switch($activity->event):
                                        case ('created'): ?>
                                            <span class="badge bg-success badge-custom">
                                                <i class="ti ti-plus me-1"></i>Created
                                            </span>
                                            <?php break; ?>
                                        <?php case ('updated'): ?>
                                            <span class="badge bg-warning badge-custom">
                                                <i class="ti ti-pencil me-1"></i>Updated
                                            </span>
                                            <?php break; ?>
                                        <?php case ('deleted'): ?>
                                            <span class="badge bg-danger badge-custom">
                                                <i class="ti ti-trash me-1"></i>Deleted
                                            </span>
                                            <?php break; ?>
                                        <?php default: ?>
                                            <span class="badge bg-secondary badge-custom">
                                                <?php echo e(ucfirst($activity->event)); ?>

                                            </span>
                                    <?php endswitch; ?>
                                </td>
                                <td>
                                    <div class="text-truncate" style="max-width: 200px;" title="<?php echo e($activity->description); ?>">
                                        <?php echo $activity->description ?? '<span class="text-muted">-</span>'; ?>

                                    </div>
                                </td>
                                <td>
                                    <div class="properties-section">
                                        <?php if($activity->event == 'updated'): ?>
                                            <div class="collapsible-properties">
                                                <strong><span class="badge bg-secondary mb-1">Old Data</span></strong>
                                                <ul class="mb-2">
                                                    <?php $__currentLoopData = $activity->properties['old'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(!is_array($value)): ?>
                                                            <li><strong><?php echo e($index); ?>:</strong> <?php echo e($value ?? '-'); ?></li>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                                <strong><span class="badge bg-success mb-1">New Data</span></strong>
                                                <ul>
                                                    <?php $__currentLoopData = $activity->properties['attributes'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(!is_array($value)): ?>
                                                            <li><strong><?php echo e($index); ?>:</strong> <?php echo e($value ?? '-'); ?></li>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                            <?php if(count($activity->properties['old'] ?? []) > 3): ?>
                                                <div class="expand-btn expand-properties">Show More</div>
                                            <?php endif; ?>
                                        <?php elseif($activity->event == 'created'): ?>
                                            <div class="collapsible-properties">
                                                <ul>
                                                    <?php $__currentLoopData = $activity->properties['attributes'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(!is_array($value)): ?>
                                                            <li><strong><?php echo e($index); ?>:</strong> <?php echo e($value ?? '-'); ?></li>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                            <?php if(count($activity->properties['attributes'] ?? []) > 3): ?>
                                                <div class="expand-btn expand-properties">Show More</div>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <div class="collapsible-properties">
                                                <ul>
                                                    <?php $__currentLoopData = $activity->properties['old'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(!is_array($value)): ?>
                                                            <li><strong><?php echo e($index); ?>:</strong> <?php echo e($value ?? '-'); ?></li>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <?php if($activity->causer): ?>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar avatar-sm me-2">
                                                <span class="avatar-initial rounded-circle bg-label-primary">
                                                    <?php echo e(substr($activity->causer->name, 0, 2)); ?>

                                                </span>
                                            </div>
                                            <div>
                                                <small class="fw-semibold"><?php echo e($activity->causer->name); ?></small>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">System</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div>
                                        <i class="ti ti-calendar me-1"></i>
                                        <small><?php echo e($activity->created_at->format('Y-m-d')); ?></small>
                                    </div>
                                    <div>
                                        <i class="ti ti-clock me-1"></i>
                                        <small><?php echo e($activity->created_at->format('h:i A')); ?></small>
                                    </div>
                                    <small class="text-muted"><?php echo e($activity->created_at->diffForHumans()); ?></small>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="mb-3">
                                        <i class="ti ti-folder-off" style="font-size: 3rem; color: #ccc;"></i>
                                    </div>
                                    <h5 class="text-muted">No Records Found</h5>
                                    <p class="text-muted">Please change the filters or search criteria</p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-between align-items-center mt-3">
                <div>
                    Showing <strong><?php echo e($activities->firstItem()); ?></strong> to 
                    <strong><?php echo e($activities->lastItem()); ?></strong> of 
                    <strong><?php echo e($activities->total()); ?></strong> results
                </div>
                <div>
                    <?php echo e($activities->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\app\logs\index.blade.php ENDPATH**/ ?>