<div>
    <style>
        .stat-card {
            border-radius: 12px;
            transition: all 0.3s ease;
            border: none;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }
        .stat-icon i {
            font-size: 24px !important;
        }
        .stat-value {
            font-size: 28px;
            font-weight: 700;
            margin: 10px 0 5px 0;
        }
        .stat-label {
            font-size: 14px;
            color: #6c757d;
            font-weight: 500;
        }
        .filter-card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .table-card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
    </style>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="mb-0">Invoice Report</h2>
    </div>

    <!-- Analysis Cards -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card stat-card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Total Invoices</div>
                            <div class="stat-value"><?php echo e(number_format($analysis['total_invoices'])); ?></div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-file-invoice"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Total Revenue</div>
                            <div class="stat-value"><?php echo e(number_format($analysis['filtered_revenue'], 2)); ?></div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-currency-dollar"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Avg Invoice Value</div>
                            <div class="stat-value"><?php echo e(number_format($analysis['filtered_avg_invoice_value'], 2)); ?></div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-chart-bar"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Today's Revenue</div>
                            <div class="stat-value"><?php echo e(number_format($analysis['today_revenue'], 2)); ?></div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-calendar-event"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Additional Stats Row -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card stat-card bg-secondary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Items Sold</div>
                            <div class="stat-value"><?php echo e(number_format($analysis['filtered_items_sold'])); ?></div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-shopping-cart"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card bg-danger text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Today's Invoices</div>
                            <div class="stat-value"><?php echo e(number_format($analysis['today_invoices'])); ?></div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-calendar"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card bg-dark text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">This Month</div>
                            <div class="stat-value"><?php echo e(number_format($analysis['month_invoices'])); ?></div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-calendar-time"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Month Revenue</div>
                            <div class="stat-value"><?php echo e(number_format($analysis['month_revenue'], 2)); ?></div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-chart-line"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters Card -->
    <div class="card filter-card mb-4">
        <div class="card-header bg-white border-bottom py-3 d-flex justify-content-between align-items-center">
            <h5 class="mb-0 text-primary"><i class="ti ti-filter me-2"></i>Filters</h5>
            <button wire:click="resetFilters" class="btn btn-outline-secondary btn-sm">
                <i class="ti ti-refresh me-1"></i> Reset
            </button>
        </div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Search</label>
                    <input type="text" wire:model.live.debounce.300ms="search" class="form-control" 
                           placeholder="Search by invoice number, patient...">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Start Date</label>
                    <input type="date" wire:model.live="startDate" class="form-control">
                </div>
                <div class="col-md-2">
                    <label class="form-label">End Date</label>
                    <input type="date" wire:model.live="endDate" class="form-control">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Status</label>
                    <select wire:model.live="status" class="form-select">
                        <option value="">All Status</option>
                        <option value="draft">Draft</option>
                        <option value="completed">Completed</option>
                        <option value="cancelled">Cancelled</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Patient</label>
                    <select wire:model.live="patient_id" class="form-select">
                        <option value="">All Patients</option>
                        <?php $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($patient->id); ?>"><?php echo e($patient->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-1">
                    <label class="form-label">Sort</label>
                    <select wire:model.live="sortBy" class="form-select">
                        <option value="created_at">Date</option>
                        <option value="total_amount">Amount</option>
                        <option value="invoice_number">Number</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Table Card -->
    <div class="card table-card">
        <div class="card-header bg-white border-bottom py-3">
            <h5 class="mb-0"><i class="ti ti-table me-2"></i>Invoices List</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th wire:click="sortByField('invoice_number')" style="cursor: pointer;">
                                Invoice #
                                <?php if($sortBy === 'invoice_number'): ?>
                                    <i class="ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th>Patient</th>
                            <th>User</th>
                            <th wire:click="sortByField('invoice_date')" style="cursor: pointer;">
                                Date
                                <?php if($sortBy === 'invoice_date'): ?>
                                    <i class="ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th>Items</th>
                            <th wire:click="sortByField('total_amount')" style="cursor: pointer;">
                                Total Amount
                                <?php if($sortBy === 'total_amount'): ?>
                                    <i class="ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><strong><?php echo e($invoice->invoice_number); ?></strong></td>
                                <td><?php echo e($invoice->patient->name ?? '-'); ?></td>
                                <td><?php echo e($invoice->user->name ?? '-'); ?></td>
                                <td><?php echo e($invoice->invoice_date->format('Y-m-d')); ?></td>
                                <td>
                                    <span class="badge bg-info"><?php echo e($invoice->items_count); ?></span>
                                </td>
                                <td><strong><?php echo e(number_format($invoice->total_amount, 2)); ?></strong></td>
                                <td>
                                    <?php if($invoice->status === 'completed'): ?>
                                        <span class="badge bg-success">Completed</span>
                                    <?php elseif($invoice->status === 'draft'): ?>
                                        <span class="badge bg-warning">Draft</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Cancelled</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('invoices.show', $invoice->id)); ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="ti ti-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <i class="ti ti-inbox ti-2x text-muted mb-2"></i>
                                    <p class="text-muted">No invoices found</p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer bg-white border-top">
            <?php echo e($invoices->links()); ?>

        </div>
    </div>
</div>

<?php /**PATH C:\Dev\doublehair\resources\views\livewire\invoice-report.blade.php ENDPATH**/ ?>