
<?php $__env->startSection('title', 'Show Invoice'); ?>

<?php $__env->startSection('content'); ?>
    <style>
        /* Invoice Styles */
        .invoice-print {
            background: white;
            max-width: 900px;
            margin: 0 auto;
        }
        
        .invoice-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 30px 0;
            border-bottom: 3px solid #667eea;
            margin-bottom: 30px;
        }
        
        .invoice-logo {
            max-width: 150px;
            height: auto;
        }
        
        .invoice-title {
            text-align: right;
        }
        
        .invoice-title h1 {
            font-size: 2.5rem;
            font-weight: 700;
            color: #667eea;
            margin: 0;
            letter-spacing: 2px;
        }
        
        .invoice-title p {
            color: #666;
            margin: 5px 0 0 0;
            font-size: 0.95rem;
        }
        
        .invoice-info-box {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #667eea;
        }
        
        .invoice-info-box h5 {
            color: #667eea;
            font-weight: 600;
            margin-bottom: 15px;
            font-size: 1.1rem;
        }
        
        .invoice-info-box p {
            margin: 8px 0;
            color: #333;
        }
        
        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin: 25px 0;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        .invoice-table thead {
            background: #6d301e;
            color: white;
        }
        
        .invoice-table th {
            padding: 15px;
            text-align: left;
            font-weight: 600;
            font-size: 0.95rem;
            letter-spacing: 0.5px;
        }
        
        .invoice-table td {
            padding: 12px 15px;
            border-bottom: 1px solid #e9ecef;
        }
        
        .invoice-table tbody tr:hover {
            background-color: #f8f9fa;
        }
        
        .invoice-table tfoot {
            background: #f8f9fa;
            font-weight: bold;
        }
        
        .invoice-table tfoot td {
            padding: 15px;
            font-size: 1.1rem;
            color: #667eea;
        }
        
        .invoice-footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 2px solid #667eea;
            text-align: center;
        }
        
        .invoice-footer p {
            color: #666;
            margin: 5px 0;
            font-style: italic;
        }
        
        .badge-status {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 600;
        }
        
        .badge-draft {
            background: #ffc107;
            color: #000;
        }
        
        .badge-completed {
            background: #28a745;
            color: white;
        }
        
        .badge-cancelled {
            background: #dc3545;
            color: white;
        }
        
        /* Print Styles */
        @media print {
            /* Hide everything first */
            body * {
                visibility: hidden;
            }
            
            /* Show only invoice content */
            .invoice-print,
            .invoice-print * {
                visibility: visible;
            }
            
            /* Position invoice at top left */
            .invoice-print {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                margin: 0;
                padding: 20px;
            }
            
            /* Hide no-print elements */
            .no-print,
            .no-print * {
                display: none !important;
                visibility: hidden !important;
            }
            
            /* Reset page margins */
            @page {
                margin: 1.5cm;
                size: A4;
            }
            
            /* Invoice styling for print */
            .invoice-print .card {
                border: none !important;
                box-shadow: none !important;
                margin: 0 !important;
                background: white !important;
            }
            
            .invoice-print .card-body {
                padding: 20px !important;
            }
            
            /* Table styling for print */
            .invoice-print table {
                border-collapse: collapse !important;
                width: 100% !important;
                margin: 15px 0 !important;
            }
            
            .invoice-print table th,
            .invoice-print table td {
                border: 1px solid #333 !important;
                padding: 8px !important;
                text-align: left;
            }
            
            .invoice-print table thead {
                background: #667eea !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .invoice-print table th {
                color: white !important;
                font-weight: bold;
            }
            
            /* Prevent page breaks inside table rows */
            .invoice-print table tr {
                page-break-inside: avoid;
            }
            
            /* Ensure text is black for print */
            .invoice-print,
            .invoice-print * {
                color: #000 !important;
            }
            
            .invoice-print .invoice-header {
                border-bottom: 3px solid #000 !important;
            }
            
            .invoice-print .invoice-table thead {
                background: #6d301e !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .invoice-print .invoice-table thead th {
                color: white !important;
            }
            
            .invoice-print .invoice-footer {
                border-top: 2px solid #000 !important;
            }
        }
    </style>
    
    <div class="card invoice-print shadow-sm">
        <div class="card-body">
            <div class="no-print mb-4">
                <h4 class="card-title d-flex align-items-center">
                    <a href="<?php echo e(route('invoices.index')); ?>" class="me-3">
                        <i class="menu-icon tf-icons ti ti-arrow-left"></i>
                    </a>
                    Invoice: <?php echo e($invoice->invoice_number); ?>

                </h4>
            </div>
            
            <!-- Invoice Header -->
            <div class="invoice-header">
                <div>
                    <img src="<?php echo e(asset('assets/logoback.png')); ?>" alt="Logo" class="invoice-logo">
                </div>
                
                <div class="invoice-title">
                    <h1>INVOICE</h1>
                    <p>Invoice #<?php echo e($invoice->invoice_number); ?></p>
                    <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #e9ecef;">
                        <p style="margin: 5px 0; font-size: 0.9rem;"> کرکوک - شارع محافضة - رۆیال موڵ</p>
                        <p style="margin: 5px 0; font-size: 0.9rem;"> 07703511020 | 07502831040</p>
                    </div>
                </div>
            </div>

            <!-- Patient and Invoice Details -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="invoice-info-box">
                        <h5>
                            <i class="menu-icon tf-icons ti ti-user me-2"></i>
                            Patient Information
                        </h5>
                        <p><strong>Name:</strong> <?php echo e($invoice->patient->name); ?></p>
                        <p><strong>Code:</strong> <code><?php echo e($invoice->patient->code); ?></code></p>
                        <?php if($invoice->patient->phone): ?>
                            <p><strong>Phone:</strong> <?php echo e($invoice->patient->phone); ?></p>
                        <?php endif; ?>
                        <?php if($invoice->patient->address): ?>
                            <p><strong>Address:</strong> <?php echo e($invoice->patient->address); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="invoice-info-box">
                        <h5>
                            <i class="menu-icon tf-icons ti ti-file-text me-2"></i>
                            Invoice Details
                        </h5>
                        <p><strong>Invoice Number:</strong> <?php echo e($invoice->invoice_number); ?></p>
                        <p><strong>Date:</strong> <?php echo e($invoice->invoice_date->format('F d, Y')); ?></p>
                        <?php if($invoice->user): ?>
                            <p><strong>Created By:</strong> <?php echo e($invoice->user->name); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Invoice Items -->
            <div class="mb-4">
                <h5 class="mb-3" style="color: #667eea; font-weight: 600;">
                    <i class="menu-icon tf-icons ti ti-list me-2"></i>
                    Invoice Items
                </h5>
                <table class="invoice-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Type</th>
                            <th>Item</th>
                            <th style="text-align: center;">Quantity</th>
                            <th style="text-align: right;">Unit Price</th>
                            <th style="text-align: right;">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $invoice->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($item->subcategory_id ? 'info' : 'primary'); ?>">
                                        <?php echo e($item->subcategory_id ? 'Service' : 'Product'); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php if($item->subcategory_id): ?>
                                        <strong><?php echo e($item->subcategory->name ?? '-'); ?></strong>
                                    <?php else: ?>
                                        <strong><?php echo e($item->product->name ?? '-'); ?></strong>
                                        <?php if($item->productBatch): ?>
                                            <br><small class="text-muted">Batch: <?php echo e($item->productBatch->batch_number ?? 'N/A'); ?></small>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td style="text-align: center;"><?php echo e($item->quantity); ?></td>
                                <td style="text-align: right;">$<?php echo e(number_format($item->unit_price, 2)); ?></td>
                                <td style="text-align: right; font-weight: 600;">$<?php echo e(number_format($item->total_price, 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="5" style="text-align: right; padding-right: 20px;">
                                <strong>Total Amount:</strong>
                            </td>
                            <td style="text-align: right; font-size: 1.2rem; color: #667eea;">
                                <strong>$<?php echo e(number_format($invoice->total_amount, 2)); ?></strong>
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <!-- Notes -->
            <?php if($invoice->notes): ?>
            <div class="invoice-info-box">
                <h5>
                    <i class="menu-icon tf-icons ti ti-notes me-2"></i>
                    Notes
                </h5>
                <p style="margin: 0; color: #555;"><?php echo e($invoice->notes); ?></p>
            </div>
            <?php endif; ?>
            
            <!-- Footer -->
            <div class="invoice-footer">
                <p style="font-size: 1rem; color: #667eea; font-weight: 600;">Thank you for your business!</p>
                <p style="font-size: 0.85rem;">We appreciate your trust in our services</p>
               
            </div>

            <!-- Action Buttons -->
            <div class="mt-4 no-print">
                <a href="<?php echo e(route('invoices.index')); ?>" class="btn btn-light">
                    <i class="menu-icon tf-icons ti ti-arrow-left me-1"></i>
                    Back
                </a>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $invoice)): ?>
                <a href="<?php echo e(route('invoices.edit', $invoice)); ?>" class="btn btn-light">
                    <i class="menu-icon tf-icons ti ti-edit me-1"></i>
                    Edit
                </a>
                <?php endif; ?>
                <button onclick="window.print()" class="btn btn-primary">
                    <i class="menu-icon tf-icons ti ti-printer me-1"></i>
                    Print
                </button>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\app\invoices\show.blade.php ENDPATH**/ ?>