<div>
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="card-title mb-0">
                    <i class="menu-icon tf-icons ti ti-package me-2"></i>
                    Products
                </h4>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Product::class)): ?>
                <a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary">
                    <i class="menu-icon tf-icons ti ti-plus me-1"></i>
                    Create Product
                </a>
                <?php endif; ?>
            </div>

            <!-- Filters -->
            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="menu-icon tf-icons ti ti-search"></i>
                        </span>
                        <input 
                            type="text" 
                            class="form-control" 
                            placeholder="Search products..." 
                            wire:model.live.debounce.300ms="search"
                        >
                    </div>
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="supplierFilter">
                        <option value="">All Suppliers</option>
                        <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="stockFilter">
                        <option value="all">All Stock</option>
                        <option value="in_stock">In Stock</option>
                        <option value="low_stock">Low Stock</option>
                        <option value="out_of_stock">Out of Stock</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button class="btn btn-outline-secondary w-100" wire:click="resetFilters">
                        <i class="menu-icon tf-icons ti ti-refresh me-1"></i>
                        Reset
                    </button>
                </div>
            </div>

            <!-- Table -->
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th style="cursor: pointer;" wire:click="sortByField('name')">
                                Name
                                <?php if($sortBy === 'name'): ?>
                                    <i class="menu-icon tf-icons ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('sale_price')">
                                Sale Price
                                <?php if($sortBy === 'sale_price'): ?>
                                    <i class="menu-icon tf-icons ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('purchase_price')">
                                Purchase Price
                                <?php if($sortBy === 'purchase_price'): ?>
                                    <i class="menu-icon tf-icons ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th>Supplier</th>
                            <th style="cursor: pointer;" wire:click="sortByField('stock_quantity')">
                                Stock Quantity
                                <?php if($sortBy === 'stock_quantity'): ?>
                                    <i class="menu-icon tf-icons ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('expired_date')">
                                Expired Date
                                <?php if($sortBy === 'expired_date'): ?>
                                    <i class="menu-icon tf-icons ti ti-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <strong><?php echo e($product->name); ?></strong>
                                    <?php if($product->description): ?>
                                        <br>
                                        <small class="text-muted"><?php echo e(Str::limit($product->description, 50)); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <strong class="text-success"><?php echo e(number_format($product->sale_price, 2)); ?></strong>
                                </td>
                                <td>
                                    <?php echo e($product->purchase_price ? number_format($product->purchase_price, 2) : '-'); ?>

                                </td>
                                <td>
                                    <?php if($product->supplier): ?>
                                        <span class="badge bg-info"><?php echo e($product->supplier->name); ?></span>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($product->stock_quantity > 10): ?>
                                        <span class="badge bg-success"><?php echo e($product->stock_quantity); ?></span>
                                    <?php elseif($product->stock_quantity > 0): ?>
                                        <span class="badge bg-warning"><?php echo e($product->stock_quantity); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">0</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($product->expired_date): ?>
                                        <span class="<?php echo e($product->expired_date->isPast() ? 'text-danger' : ($product->expired_date->isToday() ? 'text-warning' : '')); ?>">
                                            <?php echo e($product->expired_date->format('Y-m-d')); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center" style="width: 134px;">
                                    <div role="group" aria-label="Row Actions" class="btn-group">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $product)): ?>
                                        <a href="<?php echo e(route('products.show', $product)); ?>">
                                            <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $product)): ?>
                                        <a href="<?php echo e(route('products.edit', $product)); ?>">
                                            <button type="button" class="btn btn-icon btn-outline-info m-1">
                                                <i class="fa fa-edit"></i>
                                            </button>
                                        </a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $product)): ?>
                                        <button 
                                            wire:click="deleteProduct(<?php echo e($product->id); ?>)"
                                            wire:confirm="Are you sure you want to delete this product?"
                                            type="button" 
                                            class="btn btn-icon btn-outline-danger m-1"
                                        >
                                            <i class="fa fa-trash"></i>
                                        </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="menu-icon tf-icons ti ti-package fs-1 d-block mb-2"></i>
                                        No products found
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                <?php echo e($products->links()); ?>

            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('livewire:init', () => {
            Livewire.on('alert', (data) => {
                // Handle alerts if needed
            });
        });
    </script>
    <?php $__env->stopPush(); ?>
</div>

<?php /**PATH C:\Dev\doublehair\resources\views\livewire\product-list.blade.php ENDPATH**/ ?>