
<?php $__env->startSection('title', 'Patient Profile'); ?>

<?php $__env->startSection('content'); ?>
<div>
  <!-- Patient Profile Content -->
  <div class="row">
      <div class="col-xl-4 col-lg-5 col-md-5">
          <!-- About Patient -->
          <div class="card mb-4">
              <div class="card-body">
                  <div class="d-flex align-items-center justify-content-center" style="text-align: center; height: 100%;">
                      <div class="badge rounded-pill bg-label-primary">
                          <i class="menu-icon tf-icons ti ti-user" style="font-size: 72px;"></i>
                      </div>
                  </div>
                  
                  <ul class="list-unstyled mb-4 mt-3">
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-id"></i>
                          <span class="fw-bold mx-2">Patient Code:</span>
                          <span><?php echo e($patient->code ?? '-'); ?></span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-user"></i>
                          <span class="fw-bold mx-2">Patient Name:</span>
                          <span><?php echo e($patient->name ?? '-'); ?></span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-phone"></i>
                          <span class="fw-bold mx-2">Phone:</span>
                          <span><?php echo e($patient->phone ?? '-'); ?></span>
                      </li>
                      <?php if($patient->address): ?>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-map-pin"></i>
                          <span class="fw-bold mx-2">Address:</span>
                          <span><?php echo e($patient->address); ?></span>
                      </li>
                      <?php endif; ?>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-calendar"></i>
                          <span class="fw-bold mx-2">Member Since:</span>
                          <span><?php echo e($patient->created_at ? $patient->created_at->format('M d, Y') : '-'); ?></span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-receipt"></i>
                          <span class="fw-bold mx-2">Total Invoices:</span>
                          <span class="badge bg-primary"><?php echo e($patient->invoices->count()); ?></span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-currency-dollar"></i>
                          <span class="fw-bold mx-2">Total Spent:</span>
                          <span class="badge bg-success"><?php echo e(number_format($patient->invoices->sum('total_amount'), 2)); ?></span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-file-text"></i>
                          <span class="fw-bold mx-2">Medical Records:</span>
                          <span class="badge bg-info"><?php echo e($patient->histories->count()); ?></span>
                      </li>
                  </ul>

                  <div class="row d-flex justify-content-center align-items-center">
                  
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $patient)): ?>
                    <div class="col-md-12 mb-2">
                      <a href="<?php echo e(route('patients.edit', $patient)); ?>" class="btn btn-outline-info w-100">
                        <i class="tf-icons ti ti-edit"></i> Edit Patient
                      </a>
                    </div>
                    <?php endif; ?>
                  </div>
              </div>
          </div>
      </div>
      
      <div class="col-xl-8 col-lg-7 col-md-7">
          <!-- Activity Timeline -->
          <div class="col-xl-12">
              <div class="nav-align-top mb-4">
                  <div class="dropdown">
                      
                      <ul class="nav nav-pills mb-3" role="tablist">
                        <li class="nav-item">
                          <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#invoices" aria-controls="invoices" aria-selected="true">Invoice History</button>
                        </li>
                        <li class="nav-item">
                          <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#services-drugs" aria-controls="services-drugs" aria-selected="false">Services & Drugs History</button>
                        </li>
                        
                      </ul>
                      
                  </div>
                  
                  
                  <div class="tab-content">
                    
                     <div class="tab-pane fade show active" id="invoices" role="tabpanel">
                      <div class="d-flex justify-content-end mb-3">
                        
                      </div>
                      <div class="table-responsive">
                        <table class="table">
                          <thead>
                            <tr class="border-bottom">
                              <th class="text-left text-primary">Invoice Number</th>
                              <th class="text-left text-primary">Date</th>
                              <th class="text-left text-primary">Amount</th>
                              <th class="text-left text-primary">Status</th>
                              <th></th>
                            </tr>
                          </thead>
                          <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $patient->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                              <td><?php echo e($invoice->invoice_number ?? '-'); ?></td>
                              <td><?php echo e($invoice->invoice_date ? $invoice->invoice_date->format('M d, Y') : '-'); ?></td>
                              <td><strong><?php echo e(number_format($invoice->total_amount, 2)); ?></strong></td>
                              <td>
                                <span class="badge bg-<?php echo e($invoice->status === 'completed' ? 'success' : ($invoice->status === 'cancelled' ? 'danger' : 'warning')); ?>">
                                  <?php echo e(ucfirst($invoice->status)); ?>

                                </span>
                              </td>
                              <td class="text-center" style="width: 134px;">
                                <div role="group" aria-label="Row Actions" class="btn-group">
                                  <a href="<?php echo e(route('invoices.show', $invoice)); ?>">
                                    <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                      <i class="fa fa-eye"></i>
                                    </button>
                                  </a>
                                </div>
                              </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                              <td colspan="5" class="text-center py-4">
                                <p class="text-muted">No invoices found for this patient</p>
                                <a href="<?php echo e(route('invoices.create', ['patient_id' => $patient->id])); ?>" class="btn btn-primary">
                                  <i class="ti ti-plus me-2"></i>Create First Invoice
                                </a>
                              </td>
                            </tr>
                            <?php endif; ?>
                          </tbody>
                        </table>
                      </div>
                     </div>

                    
                     <div class="tab-pane fade" id="services-drugs" role="tabpanel">
                      <div class="table-responsive">
                        <table class="table">
                          <thead>
                            <tr class="border-bottom">
                              <th class="text-left text-primary">Date</th>
                              <th class="text-left text-primary">Invoice</th>
                              <th class="text-left text-primary">Type</th>
                              <th class="text-left text-primary">Item Name</th>
                              <th class="text-left text-primary">Category</th>
                              <th class="text-left text-primary">Quantity</th>
                              <th class="text-left text-primary">Unit Price</th>
                              <th class="text-left text-primary">Total</th>
                            </tr>
                          </thead>
                          <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $invoiceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                              <td><?php echo e($item->invoice->invoice_date ? $item->invoice->invoice_date->format('M d, Y') : ($item->created_at ? $item->created_at->format('M d, Y') : '-')); ?></td>
                              <td>
                                <a href="<?php echo e(route('invoices.show', $item->invoice)); ?>" class="text-primary">
                                  <?php echo e($item->invoice->invoice_number ?? 'N/A'); ?>

                                </a>
                              </td>
                              <td>
                                <?php if($item->subcategory_id): ?>
                                  <span class="badge bg-primary">Service</span>
                                <?php elseif($item->product_id): ?>
                                  <span class="badge bg-success">Drug</span>
                                <?php else: ?>
                                  <span class="badge bg-secondary">Other</span>
                                <?php endif; ?>
                              </td>
                              <td>
                                <?php if($item->subcategory_id): ?>
                                  <?php echo e($item->subcategory->name ?? 'N/A'); ?>

                                <?php elseif($item->product_id): ?>
                                  <?php echo e($item->product->name ?? 'N/A'); ?>

                                  <?php if($item->productBatch): ?>
                                    <br><small class="text-muted">Batch: <?php echo e($item->productBatch->batch_number); ?></small>
                                  <?php endif; ?>
                                <?php else: ?>
                                  N/A
                                <?php endif; ?>
                              </td>
                              <td>
                                <?php if($item->subcategory_id && $item->subcategory->category): ?>
                                  <?php echo e($item->subcategory->category->name ?? '-'); ?>

                                <?php else: ?>
                                  -
                                <?php endif; ?>
                              </td>
                              <td><?php echo e($item->quantity); ?></td>
                              <td>$<?php echo e(number_format($item->unit_price, 2)); ?></td>
                              <td><strong>$<?php echo e(number_format($item->total_price, 2)); ?></strong></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                              <td colspan="8" class="text-center py-4">
                                <p class="text-muted">No services or drugs found for this patient</p>
                              </td>
                            </tr>
                            <?php endif; ?>
                          </tbody>
                        </table>
                      </div>
                     </div>

                    
                     <div class="tab-pane fade" id="histories" role="tabpanel">
                      <div class="table-responsive">
                        <table class="table">
                          <thead>
                            <tr class="border-bottom">
                              <th class="text-left text-primary">Date</th>
                              <th class="text-left text-primary">Type</th>
                              <th class="text-left text-primary">Notes</th>
                              <th></th>
                            </tr>
                          </thead>
                          <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $patient->histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                              <td><?php echo e($history->history_date ? $history->history_date->format('M d, Y') : '-'); ?></td>
                              <td><?php echo e($history->history_type ?? 'General'); ?></td>
                              <td><?php echo e(Str::limit($history->history_notes, 100)); ?></td>
                              <td class="text-center" style="width: 134px;">
                                <div role="group" aria-label="Row Actions" class="btn-group">
                                  <a href="<?php echo e(route('patient-histories.show', $history)); ?>">
                                    <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                      <i class="fa fa-eye"></i>
                                    </button>
                                  </a>
                                </div>
                              </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                              <td colspan="4" class="text-center py-4">
                                <p class="text-muted">No medical history recorded</p>
                              </td>
                            </tr>
                            <?php endif; ?>
                          </tbody>
                        </table>
                      </div>
                     </div>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\app\patients\show.blade.php ENDPATH**/ ?>