
<?php $__env->startSection('title', 'Show Category'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="<?php echo e(route('categories.index')); ?>" class="mr-4">
                    <i class="icon ion-md-arrow-back"></i>
                </a>
                Show Category
            </h4>

            <div class="mt-4">
                <div class="mb-4">
                    <h5>Name</h5>
                    <span><?php echo e($category->name ?? '-'); ?></span>
                </div>
                <div class="mb-4">
                    <h5>Type</h5>
                    <span class="badge bg-<?php echo e($category->type === 'service' ? 'primary' : ($category->type === 'drug' ? 'success' : 'info')); ?>">
                        <?php echo e(ucfirst($category->type)); ?>

                    </span>
                </div>
                <div class="mb-4">
                    <h5>Description</h5>
                    <span><?php echo e($category->description ?? '-'); ?></span>
                </div>
                <div class="mb-4">
                    <h5>Sort Order</h5>
                    <span><?php echo e($category->sort_order ?? '-'); ?></span>
                </div>
            </div>

            <?php if($category->subcategories->count() > 0): ?>
            <div class="mt-4">
                <h5>Subcategories</h5>
                <ul>
                    <?php $__currentLoopData = $category->subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($subcategory->name); ?> - Cost: <?php echo e(number_format($subcategory->cost, 2)); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            <?php endif; ?>

            <div class="mt-4">
                <a href="<?php echo e(route('categories.index')); ?>" class="btn btn-light">
                    <i class="icon ion-md-return-left"></i>
                    Back
                </a>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $category)): ?>
                <a href="<?php echo e(route('categories.edit', $category)); ?>" class="btn btn-light">
                    <i class="icon ion-md-create"></i> Edit
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\app\categories\show.blade.php ENDPATH**/ ?>