<div>
    <div x-cloak x-data="{ open: true }" x-on:click.away="open = true" style="position: relative;">
        <?php if($label): ?>
        <label class="label-control"><?php echo e($label); ?></label>
        <?php endif; ?>
        <?php if($selectedValue == null): ?>
            <input autofocus type="text" class="<?php echo e($class); ?>" wire:model.live='search'
                x-on:click="open = true"
                id="myText"
                x-on:input="open = true"
                placeholder="<?php echo e($placeholder); ?>"
                <?php if($options->isEmpty()): ?> disabled <?php endif; ?>
                <?php if($disabled): ?> disabled <?php endif; ?>
                >

            <div  wire:loading.remove x-show="open" class="mt-2 border bg-white shadow-lg" style="position: absolute; top: 100%; left: 0; right: 0; max-height: <?php echo e($height ?? '400px'); ?>; overflow-y: auto; z-index: 999; border-radius: 8px;">
                <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $disabledOption = $disabledOptions->contains($option->id) ?>
                    <?php if(stripos($option->name, $search) !== false  ): ?>
                        <button class="<?php if($disabledOption): ?> bg-secondary <?php else: ?> bg-white <?php endif; ?> border-bottom" style="border: 0; width: 100%; text-align: left;" wire:click="selectValue(<?php echo e($option->id); ?>)" <?php if($disabledOption): ?> disabled <?php endif; ?>>
                            <h6 class="<?php if($disabledOption): ?> text-white <?php endif; ?> mx-2 mt-1"><?php echo e($option->name); ?></h6>
                        </button>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="input-group">

                <input autofocus id="myText" type="text" class="<?php echo e($class); ?>" x-on:click="open = false" value="<?php echo e($options[$selectedValue]); ?>" >

            </div>
        <?php endif; ?>
    </div>

    <script>
      window.addEventListener('load', () => {
        document.getElementById('myText').focus();
      });
    </script>

</div>
<?php /**PATH C:\Dev\doublehair\resources\views\livewire\components\custom-select-sale.blade.php ENDPATH**/ ?>