
<?php $__env->startSection('title', 'Patient Histories'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="card-title mb-0">Patient Histories</h4>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\PatientHistory::class)): ?>
                <a href="<?php echo e(route('patient-histories.create')); ?>" class="btn btn-primary">
                    <i class="icon ion-md-add"></i> Create History
                </a>
                <?php endif; ?>
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Patient</th>
                            <th>History Date</th>
                            <th>Type</th>
                            <th>Notes</th>
                            <th>Created By</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $patientHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($history->patient->name ?? '-'); ?> (<?php echo e($history->patient->code ?? '-'); ?>)</td>
                                <td><?php echo e($history->history_date->format('Y-m-d')); ?></td>
                                <td><?php echo e($history->history_type ?? 'general'); ?></td>
                                <td><?php echo e(Str::limit($history->history_notes, 50)); ?></td>
                                <td><?php echo e($history->createdBy->name ?? '-'); ?></td>
                                <td>
                                    <div role="group" class="btn-group">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $history)): ?>
                                        <a href="<?php echo e(route('patient-histories.show', $history)); ?>" class="btn btn-sm btn-outline-primary">
                                            <i class="icon ion-md-eye"></i>
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $history)): ?>
                                        <a href="<?php echo e(route('patient-histories.edit', $history)); ?>" class="btn btn-sm btn-outline-info">
                                            <i class="icon ion-md-create"></i>
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $history)): ?>
                                        <form action="<?php echo e(route('patient-histories.destroy', $history)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure?')">
                                                <i class="icon ion-md-trash"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center">No patient histories found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                <?php echo e($patientHistories->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\app\patient-histories\index.blade.php ENDPATH**/ ?>