
<?php $__env->startSection('title', 'Categories'); ?>

<?php $__env->startSection('content'); ?>
    <?php if(session()->has('errors') && session('errors')->has('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="ti ti-alert-circle me-2"></i>
            <?php echo e(session('errors')->first('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="ti ti-check me-2"></i>
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="card-title mb-0">Categories</h4>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Category::class)): ?>
                <a href="<?php echo e(route('categories.create')); ?>" class="btn btn-primary">
                    <i class="icon ion-md-add"></i> Create Category
                </a>
                <?php endif; ?>
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Description</th>
                            <th>Sort Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($category->name); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($category->type === 'service' ? 'primary' : ($category->type === 'drug' ? 'success' : 'info')); ?>">
                                        <?php echo e(ucfirst($category->type)); ?>

                                    </span>
                                </td>
                                <td><?php echo e(Str::limit($category->description, 50) ?? '-'); ?></td>
                                <td><?php echo e($category->sort_order); ?></td>
                                <td class="text-center" style="width: 134px;">
                                    <div role="group" aria-label="Row Actions" class="btn-group">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $category)): ?>
                                        <a href="<?php echo e(route('categories.show', $category)); ?>">
                                            <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $category)): ?>
                                        <a href="<?php echo e(route('categories.edit', $category)); ?>">
                                            <button type="button" class="btn btn-icon btn-outline-info m-1">
                                                <i class="fa fa-edit"></i>
                                            </button>
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $category)): ?>
                                        <form action="<?php echo e(route('categories.destroy', $category)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-icon btn-outline-danger m-1" onclick="return confirm('Are you sure?')">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center">No categories found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                <?php echo e($categories->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\app\categories\index.blade.php ENDPATH**/ ?>