
<?php $__env->startSection('title', 'Show Subcategory'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="<?php echo e(route('subcategories.index')); ?>" class="mr-4">
                    <i class="icon ion-md-arrow-back"></i>
                </a>
                Show Subcategory
            </h4>

            <div class="mt-4">
                <div class="mb-4">
                    <h5>Name</h5>
                    <span><?php echo e($subcategory->name ?? '-'); ?></span>
                </div>
                <div class="mb-4">
                    <h5>Category</h5>
                    <span><?php echo e($subcategory->category->name ?? '-'); ?></span>
                </div>
                <div class="mb-4">
                    <h5>Cost</h5>
                    <span><?php echo e(number_format($subcategory->cost, 2) ?? '-'); ?></span>
                </div>
                <div class="mb-4">
                    <h5>Description</h5>
                    <span><?php echo e($subcategory->description ?? '-'); ?></span>
                </div>
                <div class="mb-4">
                    <h5>Sort Order</h5>
                    <span><?php echo e($subcategory->sort_order ?? '-'); ?></span>
                </div>
            </div>

            <div class="mt-4">
                <a href="<?php echo e(route('subcategories.index')); ?>" class="btn btn-light">
                    <i class="icon ion-md-return-left"></i>
                    Back
                </a>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $subcategory)): ?>
                <a href="<?php echo e(route('subcategories.edit', $subcategory)); ?>" class="btn btn-light">
                    <i class="icon ion-md-create"></i> Edit
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\app\subcategories\show.blade.php ENDPATH**/ ?>