

<?php $__env->startSection('title', 'Test Notifications'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">OneSignal Test Notifications</h4>
                <p class="card-text">Test your OneSignal notification system with real users and transactions.</p>
            </div>
            <div class="card-body">
                
                <!-- Configuration Status -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="alert alert-info">
                            <h5><i class="ti ti-info-circle"></i> Configuration Status</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <strong>OneSignal App ID:</strong> 
                                    <?php if(config('onesignal.app_id')): ?>
                                        <span class="badge badge-success">Configured</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger">Not Configured</span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-md-6">
                                    <strong>REST API Key:</strong> 
                                    <?php if(config('onesignal.rest_api_key')): ?>
                                        <span class="badge badge-success">Configured</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger">Not Configured</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Users with Player IDs -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h5><i class="ti ti-users"></i> Users with OneSignal Player IDs (<?php echo e($usersWithPlayerIds->count()); ?>)</h5>
                            </div>
                            <div class="card-body">
                                <?php if($usersWithPlayerIds->count() > 0): ?>
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Email</th>
                                                    <th>Player ID</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $usersWithPlayerIds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($user->id); ?></td>
                                                    <td><?php echo e($user->name); ?></td>
                                                    <td><?php echo e($user->email); ?></td>
                                                    <td>
                                                        <code class="text-primary"><?php echo e(Str::limit($user->onesignal_player_id, 20)); ?></code>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-sm btn-primary" onclick="sendTestNotification(<?php echo e($user->id); ?>, '<?php echo e($user->name); ?>')">
                                                            <i class="ti ti-bell"></i> Send Test
                                                        </button>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-warning">
                                        <i class="ti ti-alert-triangle"></i> No users with OneSignal player IDs found. 
                                        Make sure users have logged into the mobile app to register their player IDs.
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Transactions -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h5><i class="ti ti-credit-card"></i> Recent Transactions (<?php echo e($recentTransactions->count()); ?>)</h5>
                            </div>
                            <div class="card-body">
                                <?php if($recentTransactions->count() > 0): ?>
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Type</th>
                                                    <th>Amount</th>
                                                    <th>Status</th>
                                                    <th>User</th>
                                                    <th>Date</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($transaction->id); ?></td>
                                                    <td>
                                                        <span class="badge badge-info"><?php echo e(ucfirst($transaction->transaction_type)); ?></span>
                                                    </td>
                                                    <td><?php echo e(number_format($transaction->transaction_amount, 2)); ?></td>
                                                    <td>
                                                        <?php if($transaction->status === 'approved'): ?>
                                                            <span class="badge badge-success">Approved</span>
                                                        <?php elseif($transaction->status === 'rejected'): ?>
                                                            <span class="badge badge-danger">Rejected</span>
                                                        <?php else: ?>
                                                            <span class="badge badge-warning">Pending</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if($transaction->from_account && $transaction->from_account->customer && $transaction->from_account->customer->user): ?>
                                                            <?php echo e($transaction->from_account->customer->user->name); ?>

                                                        <?php else: ?>
                                                            <span class="text-muted">No user</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo e($transaction->created_at->format('M d, Y H:i')); ?></td>
                                                    <td>
                                                        <?php if($transaction->from_account && $transaction->from_account->customer && $transaction->from_account->customer->user): ?>
                                                            <button class="btn btn-sm btn-success" onclick="sendTransactionNotification(<?php echo e($transaction->id); ?>, '<?php echo e($transaction->transaction_type); ?>')">
                                                                <i class="ti ti-send"></i> Send Notification
                                                            </button>
                                                        <?php else: ?>
                                                            <span class="text-muted">No user</span>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-warning">
                                        <i class="ti ti-alert-triangle"></i> No recent transactions found.
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Broadcast Test -->
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h5><i class="ti ti-broadcast"></i> Broadcast Test</h5>
                            </div>
                            <div class="card-body">
                                <form id="broadcastForm">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label for="broadcastMessage">Custom Message (Optional)</label>
                                        <textarea class="form-control" id="broadcastMessage" name="message" rows="3" placeholder="Leave empty for default message"></textarea>
                                    </div>
                                    <button type="button" class="btn btn-warning" onclick="sendBroadcastNotification()">
                                        <i class="ti ti-broadcast"></i> Send to All Users (<?php echo e($usersWithPlayerIds->count()); ?>)
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<!-- Test Notification Modal -->
<div class="modal fade" id="testNotificationModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Send Test Notification</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="testNotificationForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" id="testUserId" name="user_id">
                    <div class="form-group">
                        <label for="testMessage">Custom Message (Optional)</label>
                        <textarea class="form-control" id="testMessage" name="message" rows="3" placeholder="Leave empty for default message"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="submitTestNotification()">Send Notification</button>
            </div>
        </div>
    </div>
</div>

<!-- Transaction Notification Modal -->
<div class="modal fade" id="transactionNotificationModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Send Transaction Notification</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="transactionNotificationForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" id="transactionId" name="transaction_id">
                    <p>This will send a real transaction notification to the user associated with this transaction.</p>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-success" onclick="submitTransactionNotification()">Send Notification</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<script>
// Global variables
let currentUserId = null;
let currentTransactionId = null;

// Show test notification modal
function sendTestNotification(userId, userName) {
    currentUserId = userId;
    document.getElementById('testUserId').value = userId;
    document.getElementById('testMessage').value = '';
    document.querySelector('#testNotificationModal .modal-title').textContent = `Send Test Notification to ${userName}`;
    
    const modal = new bootstrap.Modal(document.getElementById('testNotificationModal'));
    modal.show();
}

// Show transaction notification modal
function sendTransactionNotification(transactionId, transactionType) {
    currentTransactionId = transactionId;
    document.getElementById('transactionId').value = transactionId;
    
    const modal = new bootstrap.Modal(document.getElementById('transactionNotificationModal'));
    modal.show();
}

// Submit test notification
function submitTestNotification() {
    const form = document.getElementById('testNotificationForm');
    const formData = new FormData(form);
    
    // Show loading state
    const submitBtn = document.querySelector('#testNotificationModal .btn-primary');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="ti ti-loader"></i> Sending...';
    submitBtn.disabled = true;
    
    fetch('<?php echo e(route("test.notification.send")); ?>', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showAlert('success', 'Success!', data.message);
            bootstrap.Modal.getInstance(document.getElementById('testNotificationModal')).hide();
        } else {
            showAlert('error', 'Error!', data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showAlert('error', 'Error!', 'Failed to send notification');
    })
    .finally(() => {
        // Reset button state
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
}

// Submit transaction notification
function submitTransactionNotification() {
    const form = document.getElementById('transactionNotificationForm');
    const formData = new FormData(form);
    
    // Show loading state
    const submitBtn = document.querySelector('#transactionNotificationModal .btn-success');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="ti ti-loader"></i> Sending...';
    submitBtn.disabled = true;
    
    fetch('<?php echo e(route("test.notification.transaction")); ?>', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showAlert('success', 'Success!', data.message);
            bootstrap.Modal.getInstance(document.getElementById('transactionNotificationModal')).hide();
        } else {
            showAlert('error', 'Error!', data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showAlert('error', 'Error!', 'Failed to send notification');
    })
    .finally(() => {
        // Reset button state
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
}

// Send broadcast notification
function sendBroadcastNotification() {
    const form = document.getElementById('broadcastForm');
    const formData = new FormData(form);
    
    // Show loading state
    const submitBtn = document.querySelector('#broadcastForm .btn-warning');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="ti ti-loader"></i> Broadcasting...';
    submitBtn.disabled = true;
    
    fetch('<?php echo e(route("test.notification.broadcast")); ?>', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showAlert('success', 'Success!', data.message);
        } else {
            showAlert('error', 'Error!', data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showAlert('error', 'Error!', 'Failed to send broadcast notification');
    })
    .finally(() => {
        // Reset button state
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
}

// Show alert function
function showAlert(type, title, message) {
    const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    const iconClass = type === 'success' ? 'ti-check-circle' : 'ti-alert-circle';
    
    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible fade show" role="alert">
            <strong><i class="ti ${iconClass}"></i> ${title}</strong><br>
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    `;
    
    // Insert alert at the top of the card body
    const cardBody = document.querySelector('.card-body');
    cardBody.insertAdjacentHTML('afterbegin', alertHtml);
    
    // Auto-dismiss after 5 seconds
    setTimeout(() => {
        const alert = cardBody.querySelector('.alert');
        if (alert) {
            const bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        }
    }, 5000);
}
</script>
<?php $__env->stopSection(); ?>




















<?php echo $__env->make('layouts.layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\test-notifications.blade.php ENDPATH**/ ?>