
<?php $__env->startSection('title', 'Show Patient History'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="<?php echo e(route('patient-histories.index')); ?>" class="mr-4">
                    <i class="icon ion-md-arrow-back"></i>
                </a>
                Show Patient History
            </h4>

            <div class="mt-4">
                <div class="mb-4">
                    <h5>Patient</h5>
                    <span><?php echo e($patientHistory->patient->name ?? '-'); ?> (<?php echo e($patientHistory->patient->code ?? '-'); ?>)</span>
                </div>
                <div class="mb-4">
                    <h5>History Date</h5>
                    <span><?php echo e($patientHistory->history_date->format('Y-m-d') ?? '-'); ?></span>
                </div>
                <div class="mb-4">
                    <h5>History Type</h5>
                    <span><?php echo e($patientHistory->history_type ?? 'general'); ?></span>
                </div>
                <div class="mb-4">
                    <h5>History Notes</h5>
                    <span><?php echo e($patientHistory->history_notes ?? '-'); ?></span>
                </div>
                <div class="mb-4">
                    <h5>Invoice</h5>
                    <span><?php echo e($patientHistory->invoice->invoice_number ?? '-'); ?></span>
                </div>
                <div class="mb-4">
                    <h5>Created By</h5>
                    <span><?php echo e($patientHistory->createdBy->name ?? '-'); ?></span>
                </div>
            </div>

            <div class="mt-4">
                <a href="<?php echo e(route('patient-histories.index')); ?>" class="btn btn-light">
                    <i class="icon ion-md-return-left"></i>
                    Back
                </a>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $patientHistory)): ?>
                <a href="<?php echo e(route('patient-histories.edit', $patientHistory)); ?>" class="btn btn-light">
                    <i class="icon ion-md-create"></i> Edit
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\doublehair\resources\views\app\patient-histories\show.blade.php ENDPATH**/ ?>