<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\language\LanguageController;
use App\Http\Controllers\pages\HomePage;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\FileUploadController;
use App\Http\Controllers\BackupController;
use App\Http\Controllers\TestNotificationController;
use App\Http\Controllers\AppVersionController;
use App\Http\Controllers\PatientController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\SubcategoryController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\PatientHistoryController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::redirect('/register', '/login');

// Privacy Policy - accessible to everyone
Route::get('/privacy-policy', function () {
    return view('privacy-policy');
})->name('privacy-policy');

Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {
    // Main Page Route
    Route::get('/', [HomePage::class, 'index'])->name('dashboard');
    
    // Language
    Route::get('lang/{locale}', [LanguageController::class, 'swap']);
    
    // File Upload Routes
    Route::get('/upload/{model}/{id}', [FileUploadController::class, 'showUploadForm'])->name('file.upload.form');
    Route::post('/upload/{model}/{id}', [FileUploadController::class, 'uploadFile'])->name('file.upload');
    Route::delete('/files/{file}', [FileUploadController::class, 'destroy'])->name('files.destroy');
  
    Route::prefix('backup')->name('backup.')->group(function () {
        Route::get('/', [BackupController::class, 'index'])->name('index');
        Route::post('/create', [BackupController::class, 'create'])->name('create');
        Route::get('/download/{filename}', [BackupController::class, 'download'])->name('download');
        Route::delete('/delete/{filename}', [BackupController::class, 'delete'])->name('delete');
        Route::get('/import', [BackupController::class, 'showImportForm'])->name('import.form');
        Route::post('/import', [BackupController::class, 'import'])->name('import');
    });
    
    // Activity Logs
    Route::get('logs', [\App\Http\Controllers\HomeController::class, 'logs'])->name('logs.index');
    Route::post('search_logs', [\App\Http\Controllers\HomeController::class, 'log_search'])->name('logs.search');
    Route::get('logs/export', [\App\Http\Controllers\HomeController::class, 'exportLogs'])->name('logs.export');

    // Test Notification Routes
    Route::get('test-notifications', [TestNotificationController::class, 'index'])->name('test.notifications');
    Route::post('test-notification/send', [TestNotificationController::class, 'sendTestNotification'])->name('test.notification.send');
    Route::post('test-notification/transaction', [TestNotificationController::class, 'sendTestTransactionNotification'])->name('test.notification.transaction');
    Route::post('test-notification/broadcast', [TestNotificationController::class, 'sendTestToAllUsers'])->name('test.notification.broadcast');
    Route::get('test-notification/config', [TestNotificationController::class, 'getConfigStatus'])->name('test.notification.config');

    // User Management Routes
    Route::resource('roles', RoleController::class);
    Route::resource('permissions', PermissionController::class);
    Route::resource('users', UserController::class);
    
    // Patient Management System Routes
    Route::resource('patients', PatientController::class);
    Route::resource('categories', CategoryController::class);
    Route::resource('subcategories', SubcategoryController::class);
    Route::resource('suppliers', SupplierController::class);
    Route::resource('products', ProductController::class)->except(['index']);
    Route::get('/products', function() {
        \Gate::authorize('view-any', \App\Models\Product::class);
        return view('app.products.index');
    })->name('products.index');
    Route::resource('invoices', InvoiceController::class);
    Route::resource('patient-histories', PatientHistoryController::class);
    
    // Patient & Invoice Wizard
    Route::get('patient-invoice-wizard', function() {
        return view('app.patients.wizard');
    })->name('patient-invoice-wizard');
    
    // Reports
    Route::get('reports/patients', function() {
        \Gate::authorize('view-any', \App\Models\Patient::class);
        return view('app.reports.patients');
    })->name('reports.patients');
    
    Route::get('reports/products', function() {
        return view('app.reports.products');
    })->name('reports.products');
    
    Route::get('reports/invoices', function() {
        return view('app.reports.invoices');
    })->name('reports.invoices');
    
    // App Version Management
    Route::get('/app-versions', [AppVersionController::class, 'index'])->name('app-versions');
});
