<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy Policy - Double Hair</title>
    <meta name="description" content="Double Hair Privacy Policy - Learn how we collect, use, and protect your information.">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f8f9fa;
        }
        
        .privacy-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 2rem;
            background: white;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            margin-top: 2rem;
            margin-bottom: 2rem;
        }
        
        .privacy-header {
            text-align: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 3px solid #007bff;
        }
        
        .privacy-title {
            color: #007bff;
            font-size: 2.5rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
        }
        
        .effective-date {
            color: #6c757d;
            font-size: 1.1rem;
            font-style: italic;
        }
        
        .section-title {
            color: #007bff;
            font-size: 1.5rem;
            font-weight: bold;
            margin-top: 2rem;
            margin-bottom: 1rem;
            padding-bottom: 0.5rem;
            border-bottom: 2px solid #e9ecef;
        }
        
        .section-content {
            margin-bottom: 1.5rem;
            text-align: justify;
        }
        
        .contact-info {
            background-color: #f8f9fa;
            padding: 1.5rem;
            border-radius: 8px;
            border-left: 4px solid #007bff;
            margin-top: 2rem;
        }
        
        .contact-title {
            color: #007bff;
            font-weight: bold;
            margin-bottom: 1rem;
        }
        
        .contact-item {
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
        }
        
        .contact-icon {
            margin-right: 0.5rem;
            font-size: 1.2rem;
        }
        
        
        .highlight {
            background-color: #fff3cd;
            padding: 0.2rem 0.4rem;
            border-radius: 4px;
            font-weight: bold;
        }
        
        ul {
            padding-left: 1.5rem;
        }
        
        li {
            margin-bottom: 0.5rem;
        }
        
        @media (max-width: 768px) {
            .privacy-container {
                margin: 1rem;
                padding: 1rem;
            }
            
            .privacy-title {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="privacy-container">
            <!-- Header -->
            <div class="privacy-header">
                <h1 class="privacy-title">Privacy Policy</h1>
                <p class="effective-date">Double Hair</p>
                <p class="effective-date">Effective Date: {{ date('F d, Y') }}</p>
            </div>

            <!-- Introduction -->
            <div class="section-content">
                <p><strong>Double Hair</strong> values your privacy. This Privacy Policy explains how we collect, use, and protect your information when you use our mobile application.</p>
            </div>

            <!-- Section 1 -->
            <h2 class="section-title">1. Information We Collect</h2>
            <div class="section-content">
                <p>We may collect the following types of information:</p>
                <ul>
                    <li><strong>Account Information:</strong> Your name, phone number, and basic details provided when you register.</li>
                    <li><strong>Transaction Information:</strong> Records of money transactions entered by your exchange shop.</li>
                    <li><strong>Device Information:</strong> Such as device type, operating system, and app usage data.</li>
                    <li><strong>Optional Information:</strong> Any information you voluntarily provide through the app.</li>
                </ul>
            </div>

            <!-- Section 2 -->
            <h2 class="section-title">2. How We Use Information</h2>
            <div class="section-content">
                <p>We use your information to:</p>
                <ul>
                    <li>Show your balances and transaction history.</li>
                    <li>Improve app performance and user experience.</li>
                    <li>Provide customer support.</li>
                    <li>Ensure the security of your account.</li>
                </ul>
            </div>

            <!-- Section 3 -->
            <h2 class="section-title">3. Information Sharing</h2>
            <div class="section-content">
                <p>We do <span class="highlight">not sell or rent</span> your personal information.</p>
                <p>We may share information only in these cases:</p>
                <ul>
                    <li>With your exchange shop (the data provider).</li>
                    <li>When required by law or government authorities.</li>
                    <li>To protect our rights, safety, or the rights of others.</li>
                </ul>
            </div>

            <!-- Section 4 -->
            <h2 class="section-title">4. Data Security</h2>
            <div class="section-content">
                <p>We use reasonable technical and organizational measures to protect your data. However, no system is 100% secure, and we cannot guarantee absolute security.</p>
            </div>

            <!-- Section 5 -->
            <h2 class="section-title">5. Your Rights</h2>
            <div class="section-content">
                <p>You have the right to:</p>
                <ul>
                    <li>Access and review your personal information.</li>
                    <li>Request correction or deletion of your information (subject to your exchange shop's policies).</li>
                    <li>Contact us with privacy concerns.</li>
                </ul>
            </div>

            <!-- Section 6 -->
            <h2 class="section-title">6. Children's Privacy</h2>
            <div class="section-content">
                <p><strong>Double Hair</strong> is not intended for children under 13. We do not knowingly collect personal data from children.</p>
            </div>

            <!-- Section 7 -->
            <h2 class="section-title">7. Changes to This Policy</h2>
            <div class="section-content">
                <p>We may update this Privacy Policy from time to time. Any changes will be posted within the app with a new "Effective Date."</p>
            </div>

            <!-- Section 8 -->
            <h2 class="section-title">8. Contact Us</h2>
            <div class="section-content">
                <p>If you have questions about this Privacy Policy, please contact us at:</p>
                
                <div class="contact-info">
                    <div class="contact-title">📧 Contact Information</div>
                    <div class="contact-item">
                        <span class="contact-icon">📧</span>
                        <span>Email: <a href="mailto:aso.sadeq@gmail.com">aso.sadeq@gmail.com</a></span>
                    </div>
                    <div class="contact-item">
                        <span class="contact-icon">📞</span>
                        <span>Phone: <a href="tel:07504305730">07504305730</a></span>
                    </div>
                </div>
            </div>

            <!-- Footer -->
            <div class="text-center mt-4 pt-3 border-top">
                <p class="text-muted">
                    <small>Last updated: {{ date('F d, Y') }} | Double Hair Privacy Policy</small>
                </p>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
