<div class="search-page">
  <style>
        .search-page {
            min-height: 100vh;
            border-radius: 10px;
            background: linear-gradient(135deg, #b09a60 0%, #b09a60 100%);
            padding: 40px 20px;
        }

        /* Dark mode for search page */
        [data-style="dark"] .search-page {
            background: linear-gradient(135deg, #1e2028 0%, #2b2d3a 100%);
        }

        .search-container {
            max-width: 1200px;
            margin: 0 auto;
        }

        .search-header {
            text-align: center;
            color: white;
            margin-bottom: 40px;
        }

        .search-logo {
            font-size: 3.5rem;
            font-weight: bold;
            margin-bottom: 10px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
        }

        .search-tagline {
            font-size: 1.2rem;
            opacity: 0.9;
        }

        .search-box-wrapper {
            background: white;
            border-radius: 50px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            padding: 8px 25px;
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
            margin-bottom: 20px;
        }

        [data-style="dark"] .search-box-wrapper {
            background: #2f3349;
            box-shadow: 0 10px 40px rgba(0,0,0,0.5);
        }

        .search-box-wrapper:focus-within {
            box-shadow: 0 15px 50px rgba(0,0,0,0.3);
            transform: translateY(-2px);
        }

        [data-style="dark"] .search-box-wrapper:focus-within {
            box-shadow: 0 15px 50px rgba(0,0,0,0.6);
        }

        .search-box-wrapper .ti {
            font-size: 1.5rem;
            color: #667eea;
            margin-right: 15px;
        }

        .search-box-wrapper input {
            border: none;
            outline: none;
            flex: 1;
            font-size: 1.1rem;
            padding: 15px 0;
            background: transparent;
            color: inherit;
        }

        [data-style="dark"] .search-box-wrapper input {
            color: #ddd;
        }

        [data-style="dark"] .search-box-wrapper input::placeholder {
            color: #888;
        }

        .search-stats {
            text-align: center;
            color: white;
            margin-bottom: 30px;
            font-size: 0.95rem;
            opacity: 0.9;
        }

        .results-container {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            min-height: 400px;
        }

        [data-style="dark"] .results-container {
            background: #2f3349;
            box-shadow: 0 10px 40px rgba(0,0,0,0.4);
        }

        .category-tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 25px;
            flex-wrap: wrap;
            border-bottom: 2px solid #e0e0e0;
            padding-bottom: 15px;
        }

        [data-style="dark"] .category-tabs {
            border-bottom-color: #3e4054;
        }

        .category-tab {
            padding: 10px 20px;
            border-radius: 20px;
            background: #f5f5f5;
            border: none;
            cursor: pointer;
            transition: all 0.3s ease;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 8px;
            color: #333;
        }

        [data-style="dark"] .category-tab {
            background: #3e4054;
            color: #ddd;
        }

        .category-tab:hover {
            background: #e0e0e0;
            transform: translateY(-2px);
        }

        [data-style="dark"] .category-tab:hover {
            background: #4a4d63;
        }

        .category-tab.active {
            background: #667eea;
            color: white;
        }

        .category-count {
            background: rgba(255,255,255,0.3);
            padding: 2px 8px;
            border-radius: 10px;
            font-size: 0.85rem;
        }

        .result-item {
            background: #f8f9fa;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 15px;
            transition: all 0.3s ease;
            border-left: 4px solid transparent;
            cursor: pointer;
        }

        [data-style="dark"] .result-item {
            background: #3e4054;
        }

        .result-item:hover {
            transform: translateX(5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            background: white;
        }

        [data-style="dark"] .result-item:hover {
            box-shadow: 0 5px 20px rgba(0,0,0,0.4);
            background: #4a4d63;
        }

        .result-item.transaction { border-left-color: #667eea; }
        .result-item.account_transaction { border-left-color: #f093fb; }
        .result-item.account { border-left-color: #4facfe; }
        .result-item.customer { border-left-color: #43e97b; }
        .result-item.user { border-left-color: #fa709a; }
        .result-item.currency { border-left-color: #feca57; }
        .result-item.cashier_shift { border-left-color: #ff6348; }

        .result-header {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 10px;
        }

        .result-icon {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.5rem;
        }

        .result-content {
            flex: 1;
        }

        .result-title {
            font-size: 1.2rem;
            font-weight: 600;
            color: #333;
            margin-bottom: 5px;
        }

        [data-style="dark"] .result-title {
            color: #ddd;
        }

        .result-subtitle {
            color: #666;
            font-size: 0.95rem;
        }

        [data-style="dark"] .result-subtitle {
            color: #aaa;
        }

        .result-description {
            color: #999;
            font-size: 0.85rem;
            margin-top: 8px;
        }

        [data-style="dark"] .result-description {
            color: #888;
        }

        .result-meta {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-top: 10px;
        }

        .result-badge {
            padding: 5px 12px;
            border-radius: 15px;
            font-size: 0.8rem;
            font-weight: 500;
        }

        .result-date {
            color: #999;
            font-size: 0.85rem;
            display: flex;
            align-items: center;
            gap: 5px;
        }

        [data-style="dark"] .result-date {
            color: #888;
        }

        .recent-searches {
            background: rgba(255,255,255,0.2);
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 20px;
        }

        .recent-searches-title {
            color: white;
            font-weight: 600;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .recent-search-item {
            background: rgba(255,255,255,0.3);
            color: white;
            padding: 8px 15px;
            border-radius: 20px;
            display: inline-block;
            margin: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 0.9rem;
        }

        .recent-search-item:hover {
            background: rgba(255,255,255,0.5);
            transform: translateY(-2px);
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #999;
        }

        [data-style="dark"] .empty-state {
            color: #777;
        }

        .empty-state .ti {
            font-size: 4rem;
            color: #ddd;
            margin-bottom: 20px;
        }

        [data-style="dark"] .empty-state .ti {
            color: #555;
        }

        .empty-state h3 {
            color: #666;
            margin-bottom: 10px;
        }

        .empty-state p {
            color: #999;
        }

        .loading-spinner {
            text-align: center;
            padding: 60px 20px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .spinner {
            border: 5px solid rgba(102, 126, 234, 0.1);
            border-top: 5px solid #667eea;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            animation: spin 0.8s linear infinite;
            margin: 0 auto;
            box-shadow: 0 0 20px rgba(102, 126, 234, 0.2);
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Inline Loading Indicator */
        .inline-loading {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            padding: 20px 30px;
            margin-bottom: 20px;
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.15);
            animation: fadeIn 0.3s ease;
        }

        .inline-loading-content {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
        }

        .inline-spinner {
            width: 20px;
            height: 20px;
            border: 3px solid rgba(102, 126, 234, 0.2);
            border-top-color: #667eea;
            border-radius: 50%;
            animation: spin 0.6s linear infinite;
        }

        .loading-text {
            color: #667eea;
            font-weight: 500;
            font-size: 1rem;
        }

        .loading-dots {
            display: flex;
            gap: 5px;
        }

        .loading-dots span {
            width: 8px;
            height: 8px;
            background: #667eea;
            border-radius: 50%;
            animation: bounce 1.4s infinite ease-in-out both;
        }

        .loading-dots span:nth-child(1) {
            animation-delay: -0.32s;
        }

        .loading-dots span:nth-child(2) {
            animation-delay: -0.16s;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes bounce {
            0%, 80%, 100% {
                transform: scale(0);
            }
            40% {
                transform: scale(1);
            }
        }

        .category-section {
            margin-bottom: 30px;
        }

        .category-header {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #f0f0f0;
        }

        .category-header .ti {
            font-size: 1.5rem;
            color: #667eea;
        }

        .category-header h3 {
            font-size: 1.3rem;
            color: #333;
            margin: 0;
        }

        .category-header .count {
            background: #667eea;
            color: white;
            padding: 3px 10px;
            border-radius: 15px;
            font-size: 0.85rem;
            margin-left: auto;
        }

        .quick-actions {
            background: rgba(255,255,255,0.2);
            border-radius: 15px;
            padding: 15px;
            margin-bottom: 20px;
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
            justify-content: center;
        }

        .quick-action-btn {
            background: rgba(255,255,255,0.3);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 20px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .quick-action-btn:hover {
            background: rgba(255,255,255,0.5);
            transform: translateY(-2px);
        }

        @media (max-width: 768px) {
            .search-logo {
                font-size: 2.5rem;
            }

            .search-box-wrapper {
                border-radius: 30px;
                padding: 5px 15px;
            }

            .result-item {
                padding: 15px;
            }

            .category-tabs {
                overflow-x: auto;
                flex-wrap: nowrap;
            }
        }
    </style>

    <div class="search-container">
        <!-- Header -->
        <div class="search-header">
            <div class="search-logo">
                <i class="ti ti-search"></i> گەڕانی گشتی
            </div>
            <div class="search-tagline">گەڕان لە هەموو زانیارییەکانی سیستەم</div>
        </div>

        <!-- Search Box -->
        <div class="search-box-wrapper">
            <i class="ti ti-search"></i>
            <input 
                type="text" 
                wire:model.live.debounce.500ms="query" 
                placeholder="گەڕان بۆ جووڵەکان، هەژمارەکان، کڕیارەکان، بەکارهێنەران و زیاتر..."
                autofocus
            >
            @if($query)
                <i class="ti ti-x" style="cursor: pointer; color: #999;" wire:click="$set('query', '')"></i>
            @endif
        </div>

        <!-- Loading Indicator Under Search Box -->
        <div wire:loading.delay wire:target="query" class="inline-loading">
            <div class="inline-loading-content">
                <div class="inline-spinner"></div>
                <span class="loading-text">گەڕان لە نێو زانیارییەکاندا...</span>
                <div class="loading-dots">
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
            </div>
        </div>

        <!-- Recent Searches -->
        @if(count($recentSearches) > 0 && !$query)
            <div class="recent-searches">
                <div class="recent-searches-title">
                    <span><i class="ti ti-history"></i> گەڕانەکانی پێشوو</span>
                    <span style="cursor: pointer; font-size: 0.9rem;" wire:click="clearRecentSearches">
                        <i class="ti ti-trash"></i> سڕینەوە
                    </span>
                </div>
                <div>
                    @foreach($recentSearches as $recentSearch)
                        <span class="recent-search-item" wire:click="searchFromRecent('{{ $recentSearch }}')">
                            {{ $recentSearch }}
                        </span>
                    @endforeach
              </div>
          </div>
        @endif

        <!-- Quick Actions -->
        @if(!$query)
            <div class="quick-actions">
                <button class="quick-action-btn" wire:click="searchFromRecent('transaction')">
                    <i class="ti ti-exchange"></i> جووڵەکان
                </button>
                <button class="quick-action-btn" wire:click="searchFromRecent('account')">
                    <i class="ti ti-wallet"></i> هەژمارەکان
                </button>
                <button class="quick-action-btn" wire:click="searchFromRecent('customer')">
                    <i class="ti ti-user"></i> کڕیارەکان
                </button>
                <button class="quick-action-btn" wire:click="searchFromRecent('user')">
                    <i class="ti ti-user-circle"></i> بەکارهێنەران
              </button>
      </div>
        @endif

        <!-- Search Stats -->
        @if($totalResults > 0)
            <div class="search-stats">
                <i class="ti ti-info-circle"></i> 
                دۆزرایەوە <strong>{{ $totalResults }}</strong> ئەنجام بۆ "<strong>{{ $query }}</strong>"
            </div>
        @endif

        <!-- Results -->
        @if($showResults && !$searching)
            <div class="results-container">
                @if($totalResults > 0)
                    <!-- Transactions -->
                    @if(count($searchResults['transactions']) > 0)
                        <div class="category-section">
                            <div class="category-header">
                                <i class="ti ti-exchange"></i>
                                <h3>جووڵەکان</h3>
                                <span class="count">{{ count($searchResults['transactions']) }}</span>
                            </div>
                            @foreach($searchResults['transactions'] as $result)
                                <a href="{{ $result['url'] }}" class="text-decoration-none">
                                    <div class="result-item {{ $result['type'] }}">
                                        <div class="result-header">
                                            <div class="result-icon">
                                                <i class="ti {{ $result['icon'] }}"></i>
                                            </div>
                                            <div class="result-content">
                                                <div class="result-title">{{ $result['title'] }}</div>
                                                <div class="result-subtitle">{{ $result['subtitle'] }}</div>
                                                <div class="result-description">{{ $result['description'] }}</div>
                                                <div class="result-meta">
                                                    <span class="result-badge bg-{{ $result['badge_color'] }} text-white">
                                                        {{ $result['badge'] }}
                                                    </span>
                                                    <span class="result-date">
                                                        <i class="ti ti-calendar"></i> {{ $result['date'] }}
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            @endforeach
      </div>
                    @endif

                    <!-- Account Transactions -->
                    @if(count($searchResults['account_transactions']) > 0)
                        <div class="category-section">
                            <div class="category-header">
                                <i class="ti ti-wallet"></i>
                                <h3>جووڵەکانی هەژمار</h3>
                                <span class="count">{{ count($searchResults['account_transactions']) }}</span>
                            </div>
                            @foreach($searchResults['account_transactions'] as $result)
                                <div class="result-item {{ $result['type'] }}">
                                    <div class="result-header">
                                        <div class="result-icon">
                                            <i class="ti {{ $result['icon'] }}"></i>
                                        </div>
                                        <div class="result-content">
                                            <div class="result-title">{{ $result['title'] }}</div>
                                            <div class="result-subtitle">{{ $result['subtitle'] }}</div>
                                            <div class="result-description">{{ $result['description'] }}</div>
                                            <div class="result-meta">
                                                <span class="result-badge bg-{{ $result['badge_color'] }} text-white">
                                                    {{ $result['badge'] }}
                                                </span>
                                                <span class="result-date">
                                                    <i class="ti ti-calendar"></i> {{ $result['date'] }}
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <!-- Accounts -->
                    @if(count($searchResults['accounts']) > 0)
                        <div class="category-section">
                            <div class="category-header">
                                <i class="ti ti-credit-card"></i>
                                <h3>هەژمارەکان</h3>
                                <span class="count">{{ count($searchResults['accounts']) }}</span>
                            </div>
                            @foreach($searchResults['accounts'] as $result)
                                <a href="{{ $result['url'] }}" class="text-decoration-none">
                                    <div class="result-item {{ $result['type'] }}">
                                        <div class="result-header">
                                            <div class="result-icon">
                                                <i class="ti {{ $result['icon'] }}"></i>
                                            </div>
                                            <div class="result-content">
                                                <div class="result-title">{{ $result['title'] }}</div>
                                                <div class="result-subtitle">{{ $result['subtitle'] }}</div>
                                                <div class="result-description">{{ $result['description'] }}</div>
                                                <div class="result-meta">
                                                    <span class="result-badge bg-{{ $result['badge_color'] }} text-white">
                                                        {{ $result['badge'] }}
                                                    </span>
                                                    <span class="result-date">
                                                        <i class="ti ti-calendar"></i> {{ $result['date'] }}
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            @endforeach
                        </div>
                    @endif

                    <!-- Customers -->
                    @if(count($searchResults['customers']) > 0)
                        <div class="category-section">
                            <div class="category-header">
                                <i class="ti ti-user"></i>
                                <h3>کڕیارەکان</h3>
                                <span class="count">{{ count($searchResults['customers']) }}</span>
                            </div>
                            @foreach($searchResults['customers'] as $result)
                                <a href="{{ $result['url'] }}" class="text-decoration-none">
                                    <div class="result-item {{ $result['type'] }}">
                                        <div class="result-header">
                                            <div class="result-icon">
                                                <i class="ti {{ $result['icon'] }}"></i>
                                            </div>
                                            <div class="result-content">
                                                <div class="result-title">{{ $result['title'] }}</div>
                                                <div class="result-subtitle">{{ $result['subtitle'] }}</div>
                                                <div class="result-description">{{ $result['description'] }}</div>
                                                <div class="result-meta">
                                                    <span class="result-badge bg-{{ $result['badge_color'] }} text-white">
                                                        {{ $result['badge'] }}
                                                    </span>
                                                    <span class="result-date">
                                                        <i class="ti ti-calendar"></i> {{ $result['date'] }}
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            @endforeach
                        </div>
                    @endif

                    <!-- Users -->
                    @if(count($searchResults['users']) > 0)
                        <div class="category-section">
                            <div class="category-header">
                                <i class="ti ti-user-circle"></i>
                                <h3>بەکارهێنەران</h3>
                                <span class="count">{{ count($searchResults['users']) }}</span>
                            </div>
                            @foreach($searchResults['users'] as $result)
                                <a href="{{ $result['url'] }}" class="text-decoration-none">
                                    <div class="result-item {{ $result['type'] }}">
                                        <div class="result-header">
                                            <div class="result-icon">
                                                <i class="ti {{ $result['icon'] }}"></i>
                                            </div>
                                            <div class="result-content">
                                                <div class="result-title">{{ $result['title'] }}</div>
                                                <div class="result-subtitle">{{ $result['subtitle'] }}</div>
                                                <div class="result-description">{{ $result['description'] }}</div>
                                                <div class="result-meta">
                                                    <span class="result-badge bg-{{ $result['badge_color'] }} text-white">
                                                        {{ $result['badge'] }}
                                                    </span>
                                                    <span class="result-date">
                                                        <i class="ti ti-calendar"></i> {{ $result['date'] }}
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            @endforeach
          </div>
                    @endif

                    <!-- Currencies -->
                    @if(count($searchResults['currencies']) > 0)
                        <div class="category-section">
                            <div class="category-header">
                                <i class="ti ti-currency-dollar"></i>
                                <h3>دراوەکان</h3>
                                <span class="count">{{ count($searchResults['currencies']) }}</span>
                            </div>
                            @foreach($searchResults['currencies'] as $result)
                                <a href="{{ $result['url'] }}" class="text-decoration-none">
                                    <div class="result-item {{ $result['type'] }}">
                                        <div class="result-header">
                                            <div class="result-icon">
                                                <i class="ti {{ $result['icon'] }}"></i>
                                            </div>
                                            <div class="result-content">
                                                <div class="result-title">{{ $result['title'] }}</div>
                                                <div class="result-subtitle">{{ $result['subtitle'] }}</div>
                                                <div class="result-description">{{ $result['description'] }}</div>
                                                <div class="result-meta">
                                                    <span class="result-badge bg-{{ $result['badge_color'] }} text-white">
                                                        {{ $result['badge'] }}
                                                    </span>
                                                    <span class="result-date">
                                                        <i class="ti ti-calendar"></i> {{ $result['date'] }}
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            @endforeach
                        </div>
                    @endif

                    <!-- Cashier Shifts -->
                    @if(count($searchResults['cashier_shifts']) > 0)
                        <div class="category-section">
                            <div class="category-header">
                                <i class="ti ti-briefcase"></i>
                                <h3>شیفتەکانی کاشیر</h3>
                                <span class="count">{{ count($searchResults['cashier_shifts']) }}</span>
                            </div>
                            @foreach($searchResults['cashier_shifts'] as $result)
                                <div class="result-item {{ $result['type'] }}">
                                    <div class="result-header">
                                        <div class="result-icon">
                                            <i class="ti {{ $result['icon'] }}"></i>
                                        </div>
                                        <div class="result-content">
                                            <div class="result-title">{{ $result['title'] }}</div>
                                            <div class="result-subtitle">{{ $result['subtitle'] }}</div>
                                            <div class="result-description">{{ $result['description'] }}</div>
                                            <div class="result-meta">
                                                <span class="result-badge bg-{{ $result['badge_color'] }} text-white">
                                                    {{ $result['badge'] }}
                                                </span>
                                                <span class="result-date">
                                                    <i class="ti ti-calendar"></i> {{ $result['date'] }}
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                @else
                    <!-- Empty State -->
                    <div class="empty-state">
                        <i class="ti ti-search-off"></i>
                        <h3>هیچ ئەنجامێک نەدۆزرایەوە</h3>
                        <p>تکایە وشەیەکی تر یان شوێنی گەڕان بگۆڕە</p>
                    </div>
                @endif
            </div>
      @endif

        @if(!$query && !$showResults)
            <div class="results-container">
                <div class="empty-state">
                    <i class="ti ti-search"></i>
                    <h3>دەست پێ بکە بە گەڕان</h3>
                    <p>وشەیەک بنووسە بۆ گەڕان لە هەموو زانیارییەکانی سیستەم</p>
                </div>
            </div>
        @endif
    </div>
  </div>
