<div>
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="card-title mb-0">
                    <i class="menu-icon tf-icons ti ti-package me-2"></i>
                    Products
                </h4>
                @can('create', App\Models\Product::class)
                <a href="{{ route('products.create') }}" class="btn btn-primary">
                    <i class="menu-icon tf-icons ti ti-plus me-1"></i>
                    Create Product
                </a>
                @endcan
            </div>

            <!-- Filters -->
            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="menu-icon tf-icons ti ti-search"></i>
                        </span>
                        <input 
                            type="text" 
                            class="form-control" 
                            placeholder="Search products..." 
                            wire:model.live.debounce.300ms="search"
                        >
                    </div>
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="supplierFilter">
                        <option value="">All Suppliers</option>
                        @foreach($suppliers as $supplier)
                            <option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="stockFilter">
                        <option value="all">All Stock</option>
                        <option value="in_stock">In Stock</option>
                        <option value="low_stock">Low Stock</option>
                        <option value="out_of_stock">Out of Stock</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button class="btn btn-outline-secondary w-100" wire:click="resetFilters">
                        <i class="menu-icon tf-icons ti ti-refresh me-1"></i>
                        Reset
                    </button>
                </div>
            </div>

            <!-- Table -->
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th style="cursor: pointer;" wire:click="sortByField('name')">
                                Name
                                @if($sortBy === 'name')
                                    <i class="menu-icon tf-icons ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('sale_price')">
                                Sale Price
                                @if($sortBy === 'sale_price')
                                    <i class="menu-icon tf-icons ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('purchase_price')">
                                Purchase Price
                                @if($sortBy === 'purchase_price')
                                    <i class="menu-icon tf-icons ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th>Supplier</th>
                            <th style="cursor: pointer;" wire:click="sortByField('stock_quantity')">
                                Stock Quantity
                                @if($sortBy === 'stock_quantity')
                                    <i class="menu-icon tf-icons ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('expired_date')">
                                Expired Date
                                @if($sortBy === 'expired_date')
                                    <i class="menu-icon tf-icons ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($products as $product)
                            <tr>
                                <td>
                                    <strong>{{ $product->name }}</strong>
                                    @if($product->description)
                                        <br>
                                        <small class="text-muted">{{ Str::limit($product->description, 50) }}</small>
                                    @endif
                                </td>
                                <td>
                                    <strong class="text-success">{{ number_format($product->sale_price, 2) }}</strong>
                                </td>
                                <td>
                                    {{ $product->purchase_price ? number_format($product->purchase_price, 2) : '-' }}
                                </td>
                                <td>
                                    @if($product->supplier)
                                        <span class="badge bg-info">{{ $product->supplier->name }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    @if($product->stock_quantity > 10)
                                        <span class="badge bg-success">{{ $product->stock_quantity }}</span>
                                    @elseif($product->stock_quantity > 0)
                                        <span class="badge bg-warning">{{ $product->stock_quantity }}</span>
                                    @else
                                        <span class="badge bg-danger">0</span>
                                    @endif
                                </td>
                                <td>
                                    @if($product->expired_date)
                                        <span class="{{ $product->expired_date->isPast() ? 'text-danger' : ($product->expired_date->isToday() ? 'text-warning' : '') }}">
                                            {{ $product->expired_date->format('Y-m-d') }}
                                        </span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-center" style="width: 134px;">
                                    <div role="group" aria-label="Row Actions" class="btn-group">
                                        @can('view', $product)
                                        <a href="{{ route('products.show', $product) }}">
                                            <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </a>
                                        @endcan

                                        @can('update', $product)
                                        <a href="{{ route('products.edit', $product) }}">
                                            <button type="button" class="btn btn-icon btn-outline-info m-1">
                                                <i class="fa fa-edit"></i>
                                            </button>
                                        </a>
                                        @endcan

                                        @can('delete', $product)
                                        <button 
                                            wire:click="deleteProduct({{ $product->id }})"
                                            wire:confirm="Are you sure you want to delete this product?"
                                            type="button" 
                                            class="btn btn-icon btn-outline-danger m-1"
                                        >
                                            <i class="fa fa-trash"></i>
                                        </button>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="menu-icon tf-icons ti ti-package fs-1 d-block mb-2"></i>
                                        No products found
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                {{ $products->links() }}
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        document.addEventListener('livewire:init', () => {
            Livewire.on('alert', (data) => {
                // Handle alerts if needed
            });
        });
    </script>
    @endpush
</div>

