<div>
    <style>
        .stat-card {
            border-radius: 12px;
            transition: all 0.3s ease;
            border: none;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }
        .stat-icon i {
            font-size: 24px !important;
        }
        .stat-value {
            font-size: 28px;
            font-weight: 700;
            margin: 10px 0 5px 0;
        }
        .stat-label {
            font-size: 14px;
            color: #6c757d;
            font-weight: 500;
        }
        .filter-card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .table-card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
    </style>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="mb-0">Patient Report</h2>
    </div>

    <!-- Analysis Cards -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card stat-card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Total Patients</div>
                            <div class="stat-value">{{ number_format($analysis['total_patients']) }}</div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-users"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Filtered Patients</div>
                            <div class="stat-value">{{ number_format($analysis['filtered_patients']) }}</div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-filter"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">Total Invoices</div>
                            <div class="stat-value">{{ number_format($analysis['total_invoices']) }}</div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-file-invoice"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label text-white-50">New This Month</div>
                            <div class="stat-value">{{ number_format($analysis['new_patients_this_month']) }}</div>
                        </div>
                        <div class="stat-icon bg-white bg-opacity-25 text-white">
                            <i class="menu-icon tf-icons ti ti-calendar"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters Card -->
    <div class="card filter-card mb-4">
        <div class="card-header bg-white border-bottom py-3 d-flex justify-content-between align-items-center">
            <h5 class="mb-0 text-primary"><i class="ti ti-filter me-2"></i>Filters</h5>
            <button wire:click="resetFilters" class="btn btn-outline-secondary btn-sm">
                <i class="ti ti-refresh me-1"></i> Reset
            </button>
        </div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Search</label>
                    <input type="text" wire:model.live.debounce.300ms="search" class="form-control" 
                           placeholder="Search by name, code, phone, or address...">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Start Date</label>
                    <input type="date" wire:model.live="startDate" class="form-control">
                </div>
                <div class="col-md-3">
                    <label class="form-label">End Date</label>
                    <input type="date" wire:model.live="endDate" class="form-control">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Sort By</label>
                    <select wire:model.live="sortBy" class="form-select">
                        <option value="created_at">Date</option>
                        <option value="name">Name</option>
                        <option value="code">Code</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Table Card -->
    <div class="card table-card">
        <div class="card-header bg-white border-bottom py-3">
            <h5 class="mb-0"><i class="ti ti-table me-2"></i>Patients List</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th wire:click="sortByField('code')" style="cursor: pointer;">
                                Code
                                @if($sortBy === 'code')
                                    <i class="ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th wire:click="sortByField('name')" style="cursor: pointer;">
                                Name
                                @if($sortBy === 'name')
                                    <i class="ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th>Phone</th>
                            <th>Address</th>
                            <th>Invoices</th>
                            <th>Histories</th>
                            <th wire:click="sortByField('created_at')" style="cursor: pointer;">
                                Created At
                                @if($sortBy === 'created_at')
                                    <i class="ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($patients as $patient)
                            <tr>
                                <td><strong>{{ $patient->code }}</strong></td>
                                <td>{{ $patient->name }}</td>
                                <td>{{ $patient->phone }}</td>
                                <td>{{ $patient->address ?? '-' }}</td>
                                <td>
                                    <span class="badge bg-info">{{ $patient->invoices_count }}</span>
                                </td>
                                <td>
                                    <span class="badge bg-secondary">{{ $patient->histories_count }}</span>
                                </td>
                                <td>{{ $patient->created_at->format('Y-m-d') }}</td>
                                <td>
                                    <a href="{{ route('patients.show', $patient->id) }}" class="btn btn-sm btn-outline-primary">
                                        <i class="ti ti-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <i class="ti ti-inbox ti-2x text-muted mb-2"></i>
                                    <p class="text-muted">No patients found</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer bg-white border-top">
            {{ $patients->links() }}
        </div>
    </div>
</div>

