<div>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title mb-0">Create Patient & Invoice</h4>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <h6 class="alert-heading"><i class="ti ti-alert-circle"></i> Please fix the following errors:</h6>
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <!-- Patient Information Section - Compact -->
            <div class="card mb-3 border-primary">
                <div class="card-body p-3">
                    @if($isEditingPatient && $selectedPatientId)
                    <div class="alert alert-info alert-sm py-2 mb-2">
                        <div class="d-flex justify-content-between align-items-center">
                            <small><i class="ti ti-info-circle me-1"></i>Editing: <strong>{{ $name }}</strong> ({{ $code }})</small>
                            <button type="button" class="btn btn-xs btn-outline-secondary btn-sm" wire:click="clearPatientSelection">
                                <i class="ti ti-x"></i>
                            </button>
                        </div>
                    </div>
                    @endif

                    <div class="row g-2">
                        <div class="col-md-3">
                            <div class="form-floating form-floating-outline position-relative">
                                <input type="text" 
                                    class="form-control form-control-sm @error('code') is-invalid @enderror" 
                                    id="code" 
                                    wire:model.live.debounce.300ms="code" 
                                    placeholder="Code" 
                                    required
                                    autocomplete="off">
                                <label for="code">Code <span class="text-danger">*</span></label>
                                @error('code') 
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                
                                @if($showSearchResults && count($searchResults) > 0)
                                <div class="position-absolute w-100 bg-white border rounded shadow-lg" style="z-index: 1000; top: 100%; margin-top: 2px; max-height: 250px; overflow-y: auto;">
                                    <div class="list-group list-group-flush">
                                        @foreach($searchResults as $result)
                                            <button type="button" 
                                                class="list-group-item list-group-item-action py-2"
                                                wire:click="selectPatient({{ $result->id }})"
                                                style="cursor: pointer;">
                                                <div class="d-flex justify-content-between">
                                                    <div>
                                                        <strong class="small">{{ $result->code }}</strong> - {{ $result->name }}
                                                        @if($result->phone)
                                                            <br><small class="text-muted">{{ $result->phone }}</small>
                                                        @endif
                                                    </div>
                                                    <i class="ti ti-arrow-right text-primary"></i>
                                                </div>
                                            </button>
                                        @endforeach
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-floating form-floating-outline position-relative">
                                <input type="text" 
                                    class="form-control form-control-sm @error('name') is-invalid @enderror" 
                                    id="name" 
                                    wire:model.live.debounce.300ms="name" 
                                    placeholder="Name" 
                                    required
                                    autocomplete="off">
                                <label for="name">Name <span class="text-danger">*</span></label>
                                @error('name') 
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                
                                @if($showSearchResults && count($searchResults) > 0)
                                <div class="position-absolute w-100 bg-white border rounded shadow-lg" style="z-index: 1000; top: 100%; margin-top: 2px; max-height: 250px; overflow-y: auto;">
                                    <div class="list-group list-group-flush">
                                        @foreach($searchResults as $result)
                                            <button type="button" 
                                                class="list-group-item list-group-item-action py-2"
                                                wire:click="selectPatient({{ $result->id }})"
                                                style="cursor: pointer;">
                                                <div class="d-flex justify-content-between">
                                                    <div>
                                                        <strong class="small">{{ $result->name }}</strong> ({{ $result->code }})
                                                        @if($result->phone)
                                                            <br><small class="text-muted">{{ $result->phone }}</small>
                                                        @endif
                                                    </div>
                                                    <i class="ti ti-arrow-right text-primary"></i>
                                                </div>
                                            </button>
                                        @endforeach
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-floating form-floating-outline">
                                <input type="text" class="form-control form-control-sm @error('phone') is-invalid @enderror" id="phone" wire:model.blur="phone" placeholder="Phone">
                                <label for="phone">Phone</label>
                                @error('phone') 
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-floating form-floating-outline">
                                <input type="text" class="form-control form-control-sm @error('address') is-invalid @enderror" id="address" wire:model.blur="address" placeholder="Address">
                                <label for="address">Address</label>
                                @error('address') 
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Invoice Items Section -->
            <div class="card mb-4">
                <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="ti ti-receipt me-2"></i>Invoice Items</h5>
                    <div>
                        <button type="button" class="btn btn-sm btn-light me-2" wire:click="openServiceModal">
                            <i class="ti ti-plus me-1"></i>Add Service
                        </button>
                        <button type="button" class="btn btn-sm btn-light" wire:click="openProductModal">
                            <i class="ti ti-plus me-1"></i>Add Drug
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    @error('items')
                        <div class="alert alert-danger">
                            <i class="ti ti-alert-circle"></i> {{ $message }}
                        </div>
                    @enderror

                    @if(count($selectedServices) == 0 && count($selectedProducts) == 0)
                        <div class="alert alert-info mb-0">
                            <i class="ti ti-info-circle me-2"></i>
                            <strong>No items added yet.</strong> Click "Add Service" or "Add Drug" to add items to the invoice.
                        </div>
                    @else
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Type</th>
                                        <th>Item Name</th>
                                        <th>Category</th>
                                        <th>Quantity</th>
                                        <th>Unit Price</th>
                                        <th>Total</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $totalAmount = 0;
                                    @endphp
                                    @foreach($selectedServices as $index => $service)
                                        @php
                                            $totalAmount += $service['cost'];
                                        @endphp
                                        <tr>
                                            <td><span class="badge bg-primary">Service</span></td>
                                            <td>{{ $service['name'] }}</td>
                                            <td>
                                                @php
                                                    $category = \App\Models\Category::find($service['category_id']);
                                                @endphp
                                                {{ $category->name ?? 'N/A' }}
                                            </td>
                                            <td>1</td>
                                            <td>${{ number_format($service['cost'], 2) }}</td>
                                            <td><strong>${{ number_format($service['cost'], 2) }}</strong></td>
                                            <td>
                                                <button type="button" class="btn btn-sm btn-danger" wire:click="removeService({{ $index }})">
                                                    <i class="ti ti-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                    @foreach($selectedProducts as $index => $product)
                                        @php
                                            $itemTotal = $product['sale_price'] * $product['quantity'];
                                            $totalAmount += $itemTotal;
                                        @endphp
                                        <tr>
                                            <td><span class="badge bg-success">Drug</span></td>
                                            <td>{{ $product['name'] }}</td>
                                            <td>-</td>
                                            <td>
                                                <div class="d-flex gap-2 align-items-center">
                                                    <input type="number" 
                                                        class="form-control form-control-sm" 
                                                        style="width: 80px;"
                                                        min="1" 
                                                        max="{{ $product['stock_quantity'] }}"
                                                        value="{{ $product['quantity'] }}"
                                                        wire:change="updateProductQuantity({{ $index }}, $event.target.value)">
                                                    @if(isset($productBatchesMap[$product['product_id']]) && $productBatchesMap[$product['product_id']]->count() > 0)
                                                        <select class="form-select form-select-sm" 
                                                            style="width: 150px;"
                                                            wire:change="updateProductBatch({{ $index }}, $event.target.value)">
                                                            <option value="">Select Batch</option>
                                                            @foreach($productBatchesMap[$product['product_id']] as $batch)
                                                                <option value="{{ $batch->id }}" {{ ($product['batch_id'] == $batch->id) ? 'selected' : '' }}>
                                                                    {{ $batch->batch_number }} ({{ $batch->available_quantity }})
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    @endif
                                                </div>
                                            </td>
                                            <td>${{ number_format($product['sale_price'], 2) }}</td>
                                            <td><strong>${{ number_format($itemTotal, 2) }}</strong></td>
                                            <td>
                                                <button type="button" class="btn btn-sm btn-danger" wire:click="removeProduct({{ $index }})">
                                                    <i class="ti ti-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="5" class="text-end">Total Amount:</th>
                                        <th class="text-primary">${{ number_format($totalAmount, 2) }}</th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Notes Section -->
            <div class="card mb-4">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0"><i class="ti ti-notes me-2"></i>Notes</h6>
                </div>
                <div class="card-body">
                    <div class="form-floating form-floating-outline">
                        <textarea class="form-control" id="notes" wire:model="notes" style="height: 120px" placeholder="Enter any additional notes for this invoice"></textarea>
                        <label for="notes">Invoice Notes (Optional)</label>
                    </div>
                </div>
            </div>

            <!-- Submit Buttons -->
            <div class="d-flex justify-content-end gap-2">
                <button type="button" class="btn btn-primary btn-lg" wire:click="saveAndPrint">
                    <i class="ti ti-printer me-2"></i>Save & Print Invoice
                </button>
                <button type="button" class="btn btn-success btn-lg" wire:click="save">
                    <i class="ti ti-check me-2"></i>Save & Reset Form
                </button>
            </div>
        </div>
    </div>

    <!-- Service Modal -->
    @if($showServiceModal)
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);" wire:click.self="closeServiceModal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title"><i class="ti ti-category me-2"></i>Add Service</h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="closeServiceModal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Search Service</label>
                        <div class="input-group">
                            <input type="text" 
                                class="form-control" 
                                wire:model.live.debounce.300ms="serviceSearchQuery"
                                placeholder="Enter service name...">
                            <button class="btn btn-primary" type="button" wire:click="searchServices">
                                <i class="ti ti-search"></i> Search
                            </button>
                        </div>
                        
                        @if($showServiceSearchResults && count($serviceSearchResults) > 0)
                            <div class="list-group mt-2" style="max-height: 400px; overflow-y: auto;">
                                @foreach($serviceSearchResults as $result)
                                    <div class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>{{ $result['name'] }}</strong>
                                            <br>
                                            <small class="text-muted">{{ $result['category_name'] }} - ${{ number_format($result['cost'], 2) }}</small>
                                        </div>
                                        <button class="btn btn-sm btn-primary" 
                                            wire:click="addService({{ $result['id'] }}, {{ $result['category_id'] }}, '{{ $result['name'] }}', {{ $result['cost'] }})">
                                            <i class="ti ti-plus"></i> Add
                                        </button>
                                    </div>
                                @endforeach
                            </div>
                        @elseif($showServiceSearchResults && strlen($serviceSearchQuery) >= 1 && count($serviceSearchResults) == 0)
                            <div class="alert alert-info mt-2 mb-0 py-2">
                                <small>No services found</small>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeServiceModal">Close</button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Product (Drug) Modal -->
    @if($showProductModal)
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);" wire:click.self="closeProductModal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title"><i class="ti ti-package me-2"></i>Add Drug</h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="closeProductModal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Search Product</label>
                        <div class="input-group">
                            <input type="text" 
                                class="form-control" 
                                wire:model.live.debounce.300ms="productSearchQuery"
                                placeholder="Enter product name...">
                            <button class="btn btn-success" type="button" wire:click="searchProducts">
                                <i class="ti ti-search"></i> Search
                            </button>
                        </div>
                        
                        @if($showProductSearchResults && count($productSearchResults) > 0)
                            <div class="list-group mt-2" style="max-height: 400px; overflow-y: auto;">
                                @foreach($productSearchResults as $result)
                                    <div class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>{{ $result['name'] }}</strong>
                                            <br>
                                            <small class="text-muted">
                                                Stock: {{ $result['stock_quantity'] }} | 
                                                Price: ${{ number_format($result['sale_price'], 2) }}
                                            </small>
                                        </div>
                                        <button class="btn btn-sm btn-success" 
                                            wire:click="addProduct({{ $result['id'] }}, '{{ $result['name'] }}', {{ $result['sale_price'] }}, {{ $result['stock_quantity'] }})">
                                            <i class="ti ti-plus"></i> Add
                                        </button>
                                    </div>
                                @endforeach
                            </div>
                        @elseif($showProductSearchResults && strlen($productSearchQuery) >= 1 && count($productSearchResults) == 0)
                            <div class="alert alert-info mt-2 mb-0 py-2">
                                <small>No products found</small>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeProductModal">Close</button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <style>
        .modal.show {
            display: block !important;
        }
        .modal-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1040;
        }
       
        .btn-xs {
            padding: 0.125rem 0.375rem;
            font-size: 0.75rem;
        }
        .form-control-sm {
            padding: 0.5rem 0.75rem;
            font-size: 0.875rem;
        }
        .form-floating > label {
            padding: 0.5rem 0.75rem;
            font-size: 0.875rem;
        }
        .form-floating > .form-control:focus ~ label,
        .form-floating > .form-control:not(:placeholder-shown) ~ label {
            transform: scale(0.85) translateY(-0.5rem) translateX(0.15rem);
        }
    </style>
</div>
