<div>
    <div class="d-flex justify-content-between mb-3">
        <h2>Invoice Management</h2>
        <button class="btn btn-primary" wire:click="openCreateModal">New Invoice</button>
    </div>

    <div class="card mt-4">
        <div class="card-body">
            <!-- Search Input -->
            <div class="d-flex justify-content-between align-items-center mb-4">
                <input 
                    type="text" 
                    class="form-control w-50" 
                    placeholder="Search invoices..." 
                    wire:model.live="searchQuery" 
                />
            </div>

            <div class="table-responsive mt-4">
                <table class="table table-border table-hover">
                    <thead>
                        <tr>
                            <th>Invoice #</th>
                            <th>Patient</th>
                            <th>Date</th>
                            <th>Total</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($invoices as $invoice)
                            <tr>
                                <td>{{ $invoice->invoice_number }}</td>
                                <td>{{ $invoice->patient->name }} ({{ $invoice->patient->code }})</td>
                                <td>{{ $invoice->invoice_date->format('Y-m-d') }}</td>
                                <td>{{ number_format($invoice->total_amount, 2) }}</td>
                                <td class="text-center">
                                    <div role="group" class="btn-group">
                                        <button wire:click="openEditModal({{ $invoice->id }})"
                                            type="button" class="btn btn-icon btn-outline-primary m-1">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <a href="{{ route('invoices.show', $invoice->id) }}">
                                            <button type="button" class="btn btn-icon btn-outline-info m-1">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-between align-items-center mt-4">
                <div>
                    <p class="mb-0">Total: {{ $invoices->total() }}</p>
                </div>
                <div>
                    {{ $invoices->links(data: ['scrollTo' => false]) }}
                </div>
            </div>
        </div>
    </div>

    <!-- Create Invoice Modal -->
    @if($showCreateModal)
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">New Invoice</h5>
                    <button type="button" class="btn-close" wire:click="closeCreateModal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <select class="form-select" id="patient_id" wire:model="patient_id" required>
                                    <option value="">Select Patient</option>
                                    @foreach($patients as $patient)
                                        <option value="{{ $patient->id }}">{{ $patient->name }} ({{ $patient->code }})</option>
                                    @endforeach
                                </select>
                                <label for="patient_id">Patient</label>
                                @error('patient_id') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="date" class="form-control" id="invoice_date" wire:model="invoice_date" required>
                                <label for="invoice_date">Invoice Date</label>
                                @error('invoice_date') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="col-md-12 mb-3">
                            <div class="form-floating">
                                <textarea class="form-control" id="notes" wire:model="notes" style="height: 100px" placeholder="Notes"></textarea>
                                <label for="notes">Notes</label>
                                @error('notes') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeCreateModal">Close</button>
                    <button wire:click="saveInvoice" type="button" class="btn btn-primary">Create Invoice</button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Edit Invoice Modal -->
    @if($showEditModal && $currentInvoice)
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Invoice: {{ $currentInvoice->invoice_number }}</h5>
                    <button type="button" class="btn-close" wire:click="closeEditModal"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="form-floating">
                                <select class="form-select" wire:model="patient_id" required>
                                    <option value="">Select Patient</option>
                                    @foreach($patients as $patient)
                                        <option value="{{ $patient->id }}">{{ $patient->name }} ({{ $patient->code }})</option>
                                    @endforeach
                                </select>
                                <label>Patient</label>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between mb-3">
                        <h6>Invoice Items</h6>
                        <button class="btn btn-sm btn-primary" wire:click="openAddItemModal">Add Item</button>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Item</th>
                                    <th>Quantity</th>
                                    <th>Unit Price</th>
                                    <th>Total</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($invoiceItems as $item)
                                    <tr>
                                        <td>{{ $item['subcategory_id'] ? 'Service' : 'Drug' }}</td>
                                        <td>
                                            @if($item['subcategory_id'])
                                                {{ \App\Models\Subcategory::find($item['subcategory_id'])->name ?? '-' }}
                                            @else
                                                {{ \App\Models\Product::find($item['product_id'])->name ?? '-' }}
                                            @endif
                                        </td>
                                        <td>{{ $item['quantity'] }}</td>
                                        <td>{{ number_format($item['unit_price'], 2) }}</td>
                                        <td>{{ number_format($item['total_price'], 2) }}</td>
                                        <td>
                                            <button wire:click="removeInvoiceItem({{ $item['id'] }})"
                                                wire:confirm="Are you sure?"
                                                class="btn btn-sm btn-danger">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="4" class="text-end">Total:</th>
                                    <th>{{ number_format($currentInvoice->total_amount ?? 0, 2) }}</th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeEditModal">Close</button>
                    <button wire:click="updateInvoice" type="button" class="btn btn-primary">Save Invoice</button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Add Item Modal -->
    @if($showAddItemModal)
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Invoice Item</h5>
                    <button type="button" class="btn-close" wire:click="closeAddItemModal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label>Item Type</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" wire:model.live="item_type" id="type_service" value="service">
                                <label class="form-check-label" for="type_service">Service</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" wire:model.live="item_type" id="type_drug" value="drug">
                                <label class="form-check-label" for="type_drug">Drug</label>
                            </div>
                        </div>

                        @if($item_type === 'service')
                            <div class="col-md-6 mb-3">
                                <div class="form-floating">
                                    <select class="form-select" wire:model.live="item_category_id">
                                        <option value="">Select Category</option>
                                        @foreach($categories as $category)
                                            @if($category->type === 'service' || $category->type === 'other')
                                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    <label>Category</label>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-floating">
                                    <select class="form-select" wire:model.live="item_subcategory_id">
                                        <option value="">Select Subcategory</option>
                                        @foreach($subcategories as $subcategory)
                                            <option value="{{ $subcategory->id }}">{{ $subcategory->name }}</option>
                                        @endforeach
                                    </select>
                                    <label>Subcategory</label>
                                    @error('item_subcategory_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>
                            </div>
                        @else
                            <div class="col-md-6 mb-3">
                                <div class="form-floating">
                                    <select class="form-select" wire:model.live="item_category_id">
                                        <option value="">Select Category</option>
                                        @foreach($categories as $category)
                                            @if($category->type === 'drug')
                                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    <label>Category</label>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-floating">
                                    <select class="form-select" wire:model.live="item_product_id">
                                        <option value="">Select Product</option>
                                        @foreach($products as $product)
                                            <option value="{{ $product->id }}">{{ $product->name }}</option>
                                        @endforeach
                                    </select>
                                    <label>Product</label>
                                    @error('item_product_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-floating">
                                    <select class="form-select" wire:model="item_product_batch_id">
                                        <option value="">Select Batch</option>
                                        @foreach($productBatches as $batch)
                                            <option value="{{ $batch->id }}">
                                                Batch: {{ $batch->batch_number ?? 'N/A' }} 
                                                (Available: {{ $batch->quantity - $batch->sold_quantity + $batch->returned_quantity }})
                                            </option>
                                        @endforeach
                                    </select>
                                    <label>Product Batch</label>
                                    @error('item_product_batch_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>
                            </div>
                        @endif

                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="number" class="form-control" wire:model="item_quantity" min="1" step="1" required>
                                <label>Quantity</label>
                                @error('item_quantity') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="number" class="form-control" wire:model="item_unit_price" min="0" step="0.01" required>
                                <label>Unit Price</label>
                                @error('item_unit_price') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="col-md-12 mb-3">
                            <div class="form-floating">
                                <textarea class="form-control" wire:model="item_notes" style="height: 80px"></textarea>
                                <label>Notes</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeAddItemModal">Close</button>
                    <button wire:click="addInvoiceItem" type="button" class="btn btn-primary">Add Item</button>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
