<div >
    <!-- Success Message with fade animation -->
    @if ($successMessage)
        <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
            <i class="bi bi-check-circle-fill me-2"></i>{{ $successMessage }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <!-- Action header with create button -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold text-primary mb-0">کاش بۆکسی خاوەنکار</h4>
        <button class="btn btn-primary px-4 rounded-pill shadow-sm" 
                wire:click="createAccounts" 
                @if($allCreated) disabled @endif>
            <i class="bi bi-plus-circle me-2"></i>دروستکردنی کاش بۆکسی خاوەنکار
        </button>
    </div>

    <!-- Currency Cards -->
    <div class="row g-4">
        @foreach ($currencies as $currency)
        @php
            // Find the account that belongs to this currency (if available)
            $account = $existingAccounts->firstWhere('currency_id', $currency->id);
        @endphp
    
        <div class="col-md-6 col-lg-3">
            <div class="card h-100 border-0 rounded-4 shadow-sm hover-shadow transition-all">
                @if ($account)
                <a href="{{ route('show-cashbox', $account->id) }}" class="text-decoration-none text-dark h-100">
                @endif
                
                <div class="card-body p-4 text-center d-flex flex-column">
                    <!-- Status Badge -->
                    <div class="position-absolute top-0 end-0 p-3">
                        @if ($account)
                            <span class="badge bg-success rounded-pill px-3 py-2">
                                <i class="bi bi-check-circle me-1"></i>بەردەستە
                            </span>
                        @else
                            <span class="badge bg-danger rounded-pill px-3 py-2">
                                <i class="bi bi-x-circle me-1"></i>بەردەست نییە
                            </span>
                        @endif
                    </div>
                
                    <!-- Currency Image with improved styling -->
                    <div class="mx-auto mb-3 mt-3">
                        <div class="avatar-circle bg-light p-3 rounded-circle mb-3 shadow-sm d-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                            <img src="{{ $currency->code ? \Storage::url($currency->code) : '' }}" 
                                alt="{{ $currency->currency_name }}" 
                                class="img-fluid rounded-circle" 
                                style="max-width: 60px; max-height: 60px;">
                        </div>
                    </div>
                    
                    <!-- Currency Name and Balance -->
                    <h5 class="card-title fw-bold mb-2">{{ $currency->currency_name }}</h5>
                    
                    @if ($account)
                        <div class="mt-2 mb-3">
                            <span class="fs-4 fw-bold text-primary">{{ number_format($account->calculateTotalBalance(), 0, '.', ',') }}</span>
                        </div>
                    @else
                        <div class="mt-2 mb-3">
                            <span class="text-muted">--</span>
                        </div>
                    @endif
                    
                    <!-- Action Button -->
                    <div class="mt-auto pt-3">
                        @if ($account)
                            <button class="btn btn-outline-primary rounded-pill px-4 w-100">
                                <i class="bi bi-eye me-2"></i>بینینی کاش بۆکس
                            </button>
                        @else
                            <button class="btn btn-outline-danger rounded-pill px-4 w-100" wire:click="createAccount({{ $currency->id }})">
                                <i class="bi bi-plus-lg me-2"></i>دروستکردن
                            </button>
                        @endif
                    </div>
                </div>
                
                @if ($account)
                </a>
                @endif
            </div>
        </div>
        @endforeach
    </div>
    
<style>
    /* Custom styles */
    .hover-shadow:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1) !important;
    }
    
    .transition-all {
        transition: all 0.3s ease;
    }
    
    /* Right-to-left support for Arabic/Kurdish */
    [dir="rtl"] .me-1, [dir="rtl"] .me-2, [dir="rtl"] .me-3 {
        margin-right: 0 !important;
    }
    
    [dir="rtl"] .me-1 {
        margin-left: 0.25rem !important;
    }
    
    [dir="rtl"] .me-2 {
        margin-left: 0.5rem !important;
    }
    
    [dir="rtl"] .me-3 {
        margin-left: 1rem !important;
    }
</style>
</div>
