@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Home')

@section('vendor-style')
<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
@endsection

@section('content')

@if(Auth::user()->hasRole('super-admin') || Auth::user()->hasRole('supervisor'))
<!-- Welcome Card -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card bg-primary text-white" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="fw-bold mb-0 text-white">@lang('word.Welcome') {{ Auth::user()->name }}</h4>
                        <p class="mb-0 text-white-50">Patient Management System Dashboard</p>
                    </div>
                    <div>
                        <i class="menu-icon tf-icons ti ti-dashboard fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Revenue Stats Cards -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0" style="border-left: 4px solid #667eea;">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted mb-2">Total Revenue</h6>
                        <h3 class="mb-0 fw-bold text-primary">{{ number_format($totalRevenue ?? 0, 2) }}</h3>
                        <small class="text-muted">All Time</small>
                    </div>
                    <div class="rounded-circle bg-primary-light p-3">
                        <i class="menu-icon tf-icons ti ti-currency-dollar fs-2 text-primary"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0" style="border-left: 4px solid #10b981;">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted mb-2">This Month</h6>
                        <h3 class="mb-0 fw-bold text-success">{{ number_format($monthRevenue ?? 0, 2) }}</h3>
                        @if(isset($revenueGrowth))
                            <small class="text-{{ $revenueGrowth >= 0 ? 'success' : 'danger' }}">
                                <i class="ti ti-arrow-{{ $revenueGrowth >= 0 ? 'up' : 'down' }}"></i>
                                {{ number_format(abs($revenueGrowth), 1) }}%
                            </small>
                        @endif
                    </div>
                    <div class="rounded-circle bg-success-light p-3">
                        <i class="menu-icon tf-icons ti ti-calendar-stats fs-2 text-success"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0" style="border-left: 4px solid #f59e0b;">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted mb-2">Today's Revenue</h6>
                        <h3 class="mb-0 fw-bold text-warning">{{ number_format($todayRevenue ?? 0, 2) }}</h3>
                        <small class="text-muted">{{ $invoicesToday ?? 0 }} invoices</small>
                    </div>
                    <div class="rounded-circle bg-warning-light p-3">
                        <i class="menu-icon tf-icons ti ti-calendar-event fs-2 text-warning"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0" style="border-left: 4px solid #ef4444;">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted mb-2">Avg Invoice</h6>
                        <h3 class="mb-0 fw-bold text-danger">
                            {{ $totalInvoices > 0 ? number_format(($totalRevenue ?? 0) / $totalInvoices, 2) : '0.00' }}
                        </h3>
                        <small class="text-muted">Per invoice</small>
                    </div>
                    <div class="rounded-circle bg-danger-light p-3">
                        <i class="menu-icon tf-icons ti ti-chart-bar fs-2 text-danger"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Stats Cards -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-body text-center">
                <div class="rounded-circle bg-primary-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-users fs-2 text-primary"></i>
                </div>
                <h3 class="mb-0 fw-bold">{{ $totalPatients ?? 0 }}</h3>
                <p class="text-muted mb-2">Total Patients</p>
                <small class="text-success">
                    <i class="ti ti-arrow-up"></i> {{ $newPatientsThisMonth ?? 0 }} this month
                </small>
                <div class="mt-3">
                    <a href="{{ route('patients.index') }}" class="btn btn-sm btn-primary">
                        <i class="ti ti-eye me-1"></i> View All
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-body text-center">
                <div class="rounded-circle bg-success-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-receipt fs-2 text-success"></i>
                </div>
                <h3 class="mb-0 fw-bold">{{ $totalInvoices ?? 0 }}</h3>
                <p class="text-muted mb-2">Total Invoices</p>
                <small class="text-info">
                    <i class="ti ti-calendar"></i> {{ $invoicesThisMonth ?? 0 }} this month
                </small>
                <div class="mt-3">
                    <a href="{{ route('invoices.index') }}" class="btn btn-sm btn-success">
                        <i class="ti ti-eye me-1"></i> View All
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-body text-center">
                <div class="rounded-circle bg-info-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-package fs-2 text-info"></i>
                </div>
                <h3 class="mb-0 fw-bold">{{ $totalProducts ?? 0 }}</h3>
                <p class="text-muted mb-2">Total Products</p>
                <small class="text-warning">
                    @if(isset($lowStockProducts) && $lowStockProducts > 0)
                        <i class="ti ti-alert-triangle"></i> {{ $lowStockProducts }} low stock
                    @else
                        <i class="ti ti-check"></i> Stock OK
                    @endif
                </small>
                <div class="mt-3">
                    <a href="{{ route('products.index') }}" class="btn btn-sm btn-info text-white">
                        <i class="ti ti-eye me-1"></i> View All
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-body text-center">
                <div class="rounded-circle bg-warning-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-alert-triangle fs-2 text-warning"></i>
                </div>
                <h3 class="mb-0 fw-bold">{{ ($lowStockProducts ?? 0) + ($outOfStockProducts ?? 0) }}</h3>
                <p class="text-muted mb-2">Stock Alerts</p>
                <small class="text-danger">
                    <i class="ti ti-x"></i> {{ $outOfStockProducts ?? 0 }} out of stock
                </small>
                <div class="mt-3">
                    <a href="{{ route('products.index') }}" class="btn btn-sm btn-warning">
                        <i class="ti ti-eye me-1"></i> View Products
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row mb-4">
    <!-- Monthly Revenue Chart -->
    <div class="col-lg-8 col-md-12 mb-3">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <h5 class="mb-0">
                    <i class="menu-icon tf-icons ti ti-chart-line me-2 text-primary"></i>
                    Monthly Revenue Trend (Last 6 Months)
                </h5>
            </div>
            <div class="card-body">
                <canvas id="monthlyRevenueChart" height="100"></canvas>
            </div>
        </div>
    </div>
    
    <!-- Invoice Status Pie Chart -->
    <div class="col-lg-4 col-md-12 mb-3">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <h5 class="mb-0">
                    <i class="menu-icon tf-icons ti ti-chart-pie me-2 text-info"></i>
                    Invoice Status
                </h5>
            </div>
            <div class="card-body">
                <canvas id="invoiceStatusChart" height="200"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Daily Revenue & Monthly Invoices -->
<div class="row mb-4">
    <!-- Daily Revenue Chart -->
    <div class="col-lg-6 col-md-12 mb-3">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <h5 class="mb-0">
                    <i class="menu-icon tf-icons ti ti-chart-bar me-2 text-success"></i>
                    Daily Revenue (Last 7 Days)
                </h5>
            </div>
            <div class="card-body">
                <canvas id="dailyRevenueChart" height="100"></canvas>
            </div>
        </div>
    </div>
    
    <!-- Monthly Invoices Chart -->
    <div class="col-lg-6 col-md-12 mb-3">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <h5 class="mb-0">
                    <i class="menu-icon tf-icons ti ti-chart-area me-2 text-warning"></i>
                    Monthly Invoices (Last 6 Months)
                </h5>
            </div>
            <div class="card-body">
                <canvas id="monthlyInvoicesChart" height="100"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Top Products & Top Patients -->
<div class="row mb-4">
    <!-- Top Products -->
    <div class="col-lg-6 col-md-12 mb-3">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="menu-icon tf-icons ti ti-package me-2 text-info"></i>
                        Top Products
                    </h5>
                    <a href="{{ route('products.index') }}" class="btn btn-sm btn-outline-info">View All</a>
                </div>
            </div>
            <div class="card-body">
                @if(isset($topProducts) && $topProducts->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm table-hover">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th class="text-end">Sold</th>
                                    <th class="text-end">Stock</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($topProducts as $product)
                                <tr>
                                    <td>
                                        <strong>{{ $product->name }}</strong>
                                        <br>
                                        <small class="text-muted">{{ number_format($product->sale_price, 2) }} each</small>
                                    </td>
                                    <td class="text-end">
                                        <span class="badge bg-success">{{ $product->total_sold ?? 0 }}</span>
                                    </td>
                                    <td class="text-end">
                                        @if($product->stock_quantity > 10)
                                            <span class="badge bg-success">{{ $product->stock_quantity }}</span>
                                        @elseif($product->stock_quantity > 0)
                                            <span class="badge bg-warning">{{ $product->stock_quantity }}</span>
                                        @else
                                            <span class="badge bg-danger">0</span>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <p class="text-muted text-center mb-0">No product sales data available</p>
                @endif
            </div>
        </div>
    </div>
    
    <!-- Top Patients -->
    <div class="col-lg-6 col-md-12 mb-3">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="menu-icon tf-icons ti ti-users me-2 text-primary"></i>
                        Top Patients
                    </h5>
                    <a href="{{ route('patients.index') }}" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
            </div>
            <div class="card-body">
                @if(isset($topPatients) && $topPatients->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm table-hover">
                            <thead>
                                <tr>
                                    <th>Patient</th>
                                    <th class="text-end">Invoices</th>
                                    <th>Code</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($topPatients as $patient)
                                <tr>
                                    <td>
                                        <strong>{{ $patient->name }}</strong>
                                        <br>
                                        <small class="text-muted">{{ $patient->phone ?? '-' }}</small>
                                    </td>
                                    <td class="text-end">
                                        <span class="badge bg-primary">{{ $patient->invoices_count }}</span>
                                    </td>
                                    <td>
                                        <code>{{ $patient->code }}</code>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <p class="text-muted text-center mb-0">No patient data available</p>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm hover-card" onclick="window.location.href = '{{ route('patients.create') }}'">
            <div class="card-body text-center">
                <div class="rounded-circle bg-primary-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-user-plus fs-2 text-primary"></i>
                </div>
                <h5 class="card-title">New Patient</h5>
                <p class="card-text small text-muted">Add a new patient</p>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm hover-card" onclick="window.location.href = '{{ route('invoices.create') }}'">
            <div class="card-body text-center">
                <div class="rounded-circle bg-success-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-file-plus fs-2 text-success"></i>
                </div>
                <h5 class="card-title">New Invoice</h5>
                <p class="card-text small text-muted">Create a new invoice</p>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm hover-card" onclick="window.location.href = '{{ route('products.create') }}'">
            <div class="card-body text-center">
                <div class="rounded-circle bg-info-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-package fs-2 text-info"></i>
                </div>
                <h5 class="card-title">New Product</h5>
                <p class="card-text small text-muted">Add a new product</p>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card h-100 shadow-sm hover-card" onclick="window.location.href = '{{ route('reports.invoices') }}'">
            <div class="card-body text-center">
                <div class="rounded-circle bg-warning-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-chart-line fs-2 text-warning"></i>
                </div>
                <h5 class="card-title">View Reports</h5>
                <p class="card-text small text-muted">Analytics & Reports</p>
            </div>
        </div>
    </div>
</div>

<!-- Recent Invoices -->
@if(isset($recentInvoices) && $recentInvoices->count() > 0)
<div class="row">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="menu-icon tf-icons ti ti-receipt me-2 text-primary"></i>
                        Recent Invoices
                    </h5>
                    <a href="{{ route('invoices.index') }}" class="btn btn-sm btn-primary">View All</a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Invoice #</th>
                                <th>Patient</th>
                                <th>Date</th>
                                <th>Total</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($recentInvoices as $invoice)
                            <tr>
                                <td><strong>{{ $invoice->invoice_number }}</strong></td>
                                <td>{{ $invoice->patient->name ?? '-' }} <small class="text-muted">({{ $invoice->patient->code ?? '-' }})</small></td>
                                <td>{{ $invoice->invoice_date->format('Y-m-d') }}</td>
                                <td><strong>{{ number_format($invoice->total_amount, 2) }}</strong></td>
                                <td>
                                    <span class="badge bg-{{ $invoice->status === 'completed' ? 'success' : ($invoice->status === 'cancelled' ? 'danger' : 'warning') }}">
                                        {{ ucfirst($invoice->status) }}
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('invoices.show', $invoice->id) }}" class="btn btn-sm btn-outline-primary">
                                        <i class="ti ti-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endif

@elseif(Auth::user()->hasRole('cashier'))
<!-- Cashier Dashboard -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card bg-primary text-white" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="fw-bold mb-0 text-white">@lang('word.Welcome') {{ Auth::user()->name }} ! 👋</h4>
                        <p class="mb-0 text-white-50">Cashier Dashboard</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-lg-6 col-md-12 mb-3">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-body text-center">
                <div class="rounded-circle bg-primary-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-receipt fs-2 text-primary"></i>
                </div>
                <h3 class="mb-0 fw-bold">{{ $totalInvoices ?? 0 }}</h3>
                <p class="text-muted mb-0">Total Invoices</p>
            </div>
        </div>
    </div>
    
    <div class="col-lg-6 col-md-12 mb-3">
        <div class="card h-100 shadow-sm border-0">
            <div class="card-body text-center">
                <div class="rounded-circle bg-success-light p-3 d-inline-flex mb-3">
                    <i class="menu-icon tf-icons ti ti-calendar fs-2 text-success"></i>
                </div>
                <h3 class="mb-0 fw-bold">{{ $invoicesToday ?? 0 }}</h3>
                <p class="text-muted mb-0">Invoices Today</p>
            </div>
        </div>
    </div>
</div>

@if(isset($recentInvoices) && $recentInvoices->count() > 0)
<div class="row">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent border-bottom">
                <h5 class="mb-0">
                    <i class="menu-icon tf-icons ti ti-receipt me-2 text-primary"></i>
                    My Recent Invoices
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Invoice #</th>
                                <th>Patient</th>
                                <th>Date</th>
                                <th>Total</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($recentInvoices as $invoice)
                            <tr>
                                <td><strong>{{ $invoice->invoice_number }}</strong></td>
                                <td>{{ $invoice->patient->name ?? '-' }}</td>
                                <td>{{ $invoice->invoice_date->format('Y-m-d') }}</td>
                                <td><strong>{{ number_format($invoice->total_amount, 2) }}</strong></td>
                                <td>
                                    <span class="badge bg-{{ $invoice->status === 'completed' ? 'success' : ($invoice->status === 'cancelled' ? 'danger' : 'warning') }}">
                                        {{ ucfirst($invoice->status) }}
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('invoices.show', $invoice->id) }}" class="btn btn-sm btn-outline-primary">
                                        <i class="ti ti-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endif

@else
<!-- Default/Other Roles -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body text-center">
                <h4 class="mb-0">@lang('word.Welcome') {{ Auth::user()->name }} ! 👋</h4>
                <p class="text-muted">Patient Management System</p>
            </div>
        </div>
    </div>
</div>
@endif

<!-- CSS for hover effects -->
<style>
    .hover-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        cursor: pointer;
    }
    
    .hover-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1) !important;
    }
    
    .bg-primary-light {
        background-color: rgba(79, 70, 229, 0.1);
    }
    
    .bg-success-light {
        background-color: rgba(40, 167, 69, 0.1);
    }
    
    .bg-info-light {
        background-color: rgba(23, 162, 184, 0.1);
    }
    
    .bg-warning-light {
        background-color: rgba(255, 193, 7, 0.1);
    }
    
    .bg-danger-light {
        background-color: rgba(239, 68, 68, 0.1);
    }
    
    .card {
        border-radius: 12px;
    }
</style>

@endsection

@section('page-script')
@if(Auth::user()->hasRole('super-admin') || Auth::user()->hasRole('supervisor'))
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Monthly Revenue Chart
    const monthlyRevenueCtx = document.getElementById('monthlyRevenueChart');
    if (monthlyRevenueCtx) {
        const monthlyRevenueData = @json($monthlyRevenue ?? []);
        new Chart(monthlyRevenueCtx, {
            type: 'line',
            data: {
                labels: monthlyRevenueData.map(item => item.month),
                datasets: [{
                    label: 'Revenue',
                    data: monthlyRevenueData.map(item => item.revenue),
                    borderColor: 'rgb(102, 126, 234)',
                    backgroundColor: 'rgba(102, 126, 234, 0.1)',
                    tension: 0.4,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return value.toLocaleString();
                            }
                        }
                    }
                }
            }
        });
    }

    // Invoice Status Pie Chart
    const invoiceStatusCtx = document.getElementById('invoiceStatusChart');
    if (invoiceStatusCtx) {
        const invoicesByStatus = @json($invoicesByStatus ?? []);
        const statusData = {
            labels: invoicesByStatus.map(item => item.status.charAt(0).toUpperCase() + item.status.slice(1)),
            datasets: [{
                data: invoicesByStatus.map(item => item.total),
                backgroundColor: [
                    'rgba(40, 167, 69, 0.8)',   // success - green
                    'rgba(255, 193, 7, 0.8)',    // warning - yellow
                    'rgba(239, 68, 68, 0.8)'     // danger - red
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        };
        
        new Chart(invoiceStatusCtx, {
            type: 'doughnut',
            data: statusData,
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        position: 'bottom'
                    }
                }
            }
        });
    }

    // Daily Revenue Chart
    const dailyRevenueCtx = document.getElementById('dailyRevenueChart');
    if (dailyRevenueCtx) {
        const dailyRevenueData = @json($dailyRevenue ?? []);
        new Chart(dailyRevenueCtx, {
            type: 'bar',
            data: {
                labels: dailyRevenueData.map(item => item.day),
                datasets: [{
                    label: 'Revenue',
                    data: dailyRevenueData.map(item => item.revenue),
                    backgroundColor: 'rgba(40, 167, 69, 0.8)',
                    borderColor: 'rgb(40, 167, 69)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return value.toLocaleString();
                            }
                        }
                    }
                }
            }
        });
    }

    // Monthly Invoices Chart
    const monthlyInvoicesCtx = document.getElementById('monthlyInvoicesChart');
    if (monthlyInvoicesCtx) {
        const monthlyInvoicesData = @json($monthlyInvoices ?? []);
        new Chart(monthlyInvoicesCtx, {
            type: 'bar',
            data: {
                labels: monthlyInvoicesData.map(item => item.month),
                datasets: [{
                    label: 'Invoices',
                    data: monthlyInvoicesData.map(item => item.count),
                    backgroundColor: 'rgba(255, 193, 7, 0.8)',
                    borderColor: 'rgb(255, 193, 7)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                }
            }
        });
    }
});
</script>
@endif
@endsection
