@extends('layouts/layoutMaster')
@section('title', 'Subcategories')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="card-title mb-0">Subcategories</h4>
                @can('create', App\Models\Subcategory::class)
                <a href="{{ route('subcategories.create') }}" class="btn btn-primary">
                    <i class="icon ion-md-add"></i> Create Subcategory
                </a>
                @endcan
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Category</th>
                            <th>Cost</th>
                            <th>Description</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($subcategories as $subcategory)
                            <tr>
                                <td>{{ $subcategory->name }}</td>
                                <td>{{ $subcategory->category->name ?? '-' }}</td>
                                <td>{{ number_format($subcategory->cost, 2) }}</td>
                                <td>{{ Str::limit($subcategory->description, 50) ?? '-' }}</td>
                                <td class="text-center" style="width: 134px;">
                                    <div role="group" aria-label="Row Actions" class="btn-group">
                                        @can('view', $subcategory)
                                        <a href="{{ route('subcategories.show', $subcategory) }}">
                                            <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </a>
                                        @endcan
                                        @can('update', $subcategory)
                                        <a href="{{ route('subcategories.edit', $subcategory) }}">
                                            <button type="button" class="btn btn-icon btn-outline-info m-1">
                                                <i class="fa fa-edit"></i>
                                            </button>
                                        </a>
                                        @endcan
                                        @can('delete', $subcategory)
                                        <form action="{{ route('subcategories.destroy', $subcategory) }}" method="POST" class="d-inline">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="btn btn-icon btn-outline-danger m-1" onclick="return confirm('Are you sure?')">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </form>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">No subcategories found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                {{ $subcategories->links() }}
            </div>
        </div>
    </div>
@endsection

