@php $editing = isset($subcategory) @endphp

<div class="row">
    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.select name="category_id" label="Category" required>
            <option value="">Select Category</option>
            @foreach($categories as $id => $name)
                <option value="{{ $id }}" {{ old('category_id', ($editing ? $subcategory->category_id : '')) == $id ? 'selected' : '' }}>
                    {{ $name }}
                </option>
            @endforeach
        </x-inputs.select>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.text
            name="name"
            label="Subcategory Name"
            :value="old('name', ($editing ? $subcategory->name : ''))"
            maxlength="255"
            placeholder="Subcategory Name"
            required
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.number
            name="cost"
            label="Cost"
            :value="old('cost', ($editing ? $subcategory->cost : '0'))"
            step="0.01"
            placeholder="Cost"
            required
        ></x-inputs.number>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.number
            name="sort_order"
            label="Sort Order"
            :value="old('sort_order', ($editing ? $subcategory->sort_order : '0'))"
            placeholder="Sort Order"
        ></x-inputs.number>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.textarea name="description" label="Description"
            >{{ old('description', ($editing ? $subcategory->description : '')) }}</x-inputs.textarea
        >
    </x-inputs.group>
</div>

