@extends('layouts/layoutMaster')
@section('title', 'Create Patient & Invoice')

@section('vendor-style')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
@endsection

@section('content')
@livewire('patient-invoice-wizard')
@endsection

@section('page-script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        if (typeof toastr !== 'undefined') {
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "timeOut": "5000"
            };
        }
        
        // Close search dropdown when clicking outside
        document.addEventListener('click', function(event) {
            const searchDropdowns = document.querySelectorAll('.list-group');
            searchDropdowns.forEach(function(dropdown) {
                const input = dropdown.closest('.position-relative')?.querySelector('input');
                if (input && !input.contains(event.target) && !dropdown.contains(event.target)) {
                    // Dropdown will be hidden by Livewire when search results are cleared
                }
            });
        });
    });
    
    window.addEventListener('alert', function(event) {
        if (typeof toastr !== 'undefined') {
            const type = event.detail.type || 'info';
            const message = event.detail.message || '';
            const title = event.detail.title || '';
            
            if (toastr[type]) {
                toastr[type](message, title);
            } else {
                toastr.info(message, title);
            }
        } else {
            alert((event.detail.type || 'info').toUpperCase() + ': ' + (event.detail.message || ''));
        }
    });
</script>
@endsection

