@extends('layouts/layoutMaster')
@section('title', 'Edit Patient')

@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('patients.show', $patient) }}" class="mr-4">
                    <i class="icon ion-md-arrow-back"></i>
                </a>
                Edit Patient
            </h4>

            <form method="POST" action="{{ route('patients.update', $patient) }}" class="mt-4">
                @csrf
                @method('PUT')
                @include('app.patients.form-inputs')

                <div class="mt-4">
                    <a href="{{ route('patients.show', $patient) }}" class="btn btn-light">
                        <i class="icon ion-md-return-left text-primary"></i>
                        Back
                    </a>
                    <button type="submit" class="btn btn-primary float-right">
                        <i class="icon ion-md-save"></i>
                        Update
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

