@extends('layouts/layoutMaster')
@section('title', 'Show Patient History')

@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('patient-histories.index') }}" class="mr-4">
                    <i class="icon ion-md-arrow-back"></i>
                </a>
                Show Patient History
            </h4>

            <div class="mt-4">
                <div class="mb-4">
                    <h5>Patient</h5>
                    <span>{{ $patientHistory->patient->name ?? '-' }} ({{ $patientHistory->patient->code ?? '-' }})</span>
                </div>
                <div class="mb-4">
                    <h5>History Date</h5>
                    <span>{{ $patientHistory->history_date->format('Y-m-d') ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>History Type</h5>
                    <span>{{ $patientHistory->history_type ?? 'general' }}</span>
                </div>
                <div class="mb-4">
                    <h5>History Notes</h5>
                    <span>{{ $patientHistory->history_notes ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>Invoice</h5>
                    <span>{{ $patientHistory->invoice->invoice_number ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>Created By</h5>
                    <span>{{ $patientHistory->createdBy->name ?? '-' }}</span>
                </div>
            </div>

            <div class="mt-4">
                <a href="{{ route('patient-histories.index') }}" class="btn btn-light">
                    <i class="icon ion-md-return-left"></i>
                    Back
                </a>
                @can('update', $patientHistory)
                <a href="{{ route('patient-histories.edit', $patientHistory) }}" class="btn btn-light">
                    <i class="icon ion-md-create"></i> Edit
                </a>
                @endcan
            </div>
        </div>
    </div>
@endsection

