@extends('layouts/layoutMaster')
@section('title', 'Patient Histories')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="card-title mb-0">Patient Histories</h4>
                @can('create', App\Models\PatientHistory::class)
                <a href="{{ route('patient-histories.create') }}" class="btn btn-primary">
                    <i class="icon ion-md-add"></i> Create History
                </a>
                @endcan
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Patient</th>
                            <th>History Date</th>
                            <th>Type</th>
                            <th>Notes</th>
                            <th>Created By</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($patientHistories as $history)
                            <tr>
                                <td>{{ $history->patient->name ?? '-' }} ({{ $history->patient->code ?? '-' }})</td>
                                <td>{{ $history->history_date->format('Y-m-d') }}</td>
                                <td>{{ $history->history_type ?? 'general' }}</td>
                                <td>{{ Str::limit($history->history_notes, 50) }}</td>
                                <td>{{ $history->createdBy->name ?? '-' }}</td>
                                <td>
                                    <div role="group" class="btn-group">
                                        @can('view', $history)
                                        <a href="{{ route('patient-histories.show', $history) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="icon ion-md-eye"></i>
                                        </a>
                                        @endcan
                                        @can('update', $history)
                                        <a href="{{ route('patient-histories.edit', $history) }}" class="btn btn-sm btn-outline-info">
                                            <i class="icon ion-md-create"></i>
                                        </a>
                                        @endcan
                                        @can('delete', $history)
                                        <form action="{{ route('patient-histories.destroy', $history) }}" method="POST" class="d-inline">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure?')">
                                                <i class="icon ion-md-trash"></i>
                                            </button>
                                        </form>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center">No patient histories found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                {{ $patientHistories->links() }}
            </div>
        </div>
    </div>
@endsection

