@php $editing = isset($patientHistory) @endphp

<div class="row">
    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.select name="patient_id" label="Patient" required>
            <option value="">Select Patient</option>
            @foreach($patients as $id => $name)
                <option value="{{ $id }}" {{ old('patient_id', ($editing ? $patientHistory->patient_id : '')) == $id ? 'selected' : '' }}>
                    {{ $name }}
                </option>
            @endforeach
        </x-inputs.select>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.select name="invoice_id" label="Invoice">
            <option value="">Select Invoice (Optional)</option>
            @foreach($invoices as $id => $invoiceNumber)
                <option value="{{ $id }}" {{ old('invoice_id', ($editing ? $patientHistory->invoice_id : '')) == $id ? 'selected' : '' }}>
                    {{ $invoiceNumber }}
                </option>
            @endforeach
        </x-inputs.select>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.date
            name="history_date"
            label="History Date"
            :value="old('history_date', ($editing ? $patientHistory->history_date : ''))"
            required
        ></x-inputs.date>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.text
            name="history_type"
            label="History Type"
            :value="old('history_type', ($editing ? $patientHistory->history_type : 'general'))"
            maxlength="255"
            placeholder="History Type (e.g., general, treatment, diagnosis)"
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.textarea name="history_notes" label="History Notes" required
            >{{ old('history_notes', ($editing ? $patientHistory->history_notes : '')) }}</x-inputs.textarea
        >
    </x-inputs.group>
</div>

