@extends('layouts/layoutMaster')
@section('title', 'Invoices')

@section('content')
    @if (session()->has('errors') && session('errors')->has('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="ti ti-alert-circle me-2"></i>
            {{ session('errors')->first('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="ti ti-check me-2"></i>
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    
    @livewire('invoice-list')
@endsection

@section('page-script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        if (typeof toastr !== 'undefined') {
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "timeOut": "5000"
            };
        }
        
        window.addEventListener('alert', function(event) {
            if (typeof toastr !== 'undefined') {
                const type = event.detail.type || 'info';
                const message = event.detail.message || '';
                const title = event.detail.title || '';
                
                if (toastr[type]) {
                    toastr[type](message, title);
                } else {
                    toastr.info(message, title);
                }
            }
        });
    });
</script>
@endsection

