@extends('layouts/layoutMaster')
@section('title', 'Categories')

@section('content')
    @if (session()->has('errors') && session('errors')->has('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="ti ti-alert-circle me-2"></i>
            {{ session('errors')->first('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="ti ti-check me-2"></i>
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="card-title mb-0">Categories</h4>
                @can('create', App\Models\Category::class)
                <a href="{{ route('categories.create') }}" class="btn btn-primary">
                    <i class="icon ion-md-add"></i> Create Category
                </a>
                @endcan
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Description</th>
                            <th>Sort Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($categories as $category)
                            <tr>
                                <td>{{ $category->name }}</td>
                                <td>
                                    <span class="badge bg-{{ $category->type === 'service' ? 'primary' : ($category->type === 'drug' ? 'success' : 'info') }}">
                                        {{ ucfirst($category->type) }}
                                    </span>
                                </td>
                                <td>{{ Str::limit($category->description, 50) ?? '-' }}</td>
                                <td>{{ $category->sort_order }}</td>
                                <td class="text-center" style="width: 134px;">
                                    <div role="group" aria-label="Row Actions" class="btn-group">
                                        @can('view', $category)
                                        <a href="{{ route('categories.show', $category) }}">
                                            <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </a>
                                        @endcan
                                        @can('update', $category)
                                        <a href="{{ route('categories.edit', $category) }}">
                                            <button type="button" class="btn btn-icon btn-outline-info m-1">
                                                <i class="fa fa-edit"></i>
                                            </button>
                                        </a>
                                        @endcan
                                        @can('delete', $category)
                                        <form action="{{ route('categories.destroy', $category) }}" method="POST" class="d-inline">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="btn btn-icon btn-outline-danger m-1" onclick="return confirm('Are you sure?')">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </form>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">No categories found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                {{ $categories->links() }}
            </div>
        </div>
    </div>
@endsection

