@extends('layouts/layoutMaster')
@section('title', 'Edit Category')

@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('categories.index') }}" class="mr-4">
                    <i class="icon ion-md-arrow-back"></i>
                </a>
                Edit Category
            </h4>

            <form method="POST" action="{{ route('categories.update', $category) }}" class="mt-4">
                @csrf
                @method('PUT')
                @include('app.categories.form-inputs')

                <div class="mt-4">
                    <a href="{{ route('categories.index') }}" class="btn btn-light">
                        <i class="icon ion-md-return-left text-primary"></i>
                        Back
                    </a>
                    <button type="submit" class="btn btn-primary float-right">
                        <i class="icon ion-md-save"></i>
                        Update
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

