#!/bin/bash

# Double Hair Production Deployment Script
# Make sure to run this script from the project root directory

echo "🚀 Starting Double Hair Production Deployment..."

# Check if we're in the right directory
if [ ! -f "artisan" ]; then
    echo "❌ Error: Please run this script from the Laravel project root directory"
    exit 1
fi

# Set production environment
echo "📝 Setting production environment..."
cp .env.example .env.production
sed -i 's/APP_ENV=local/APP_ENV=production/' .env.production
sed -i 's/APP_DEBUG=true/APP_DEBUG=false/' .env.production

# Install/Update dependencies
echo "📦 Installing dependencies..."
composer install --no-dev --optimize-autoloader

# Generate application key
echo "🔑 Generating application key..."
php artisan key:generate --env=production

# Run database migrations
echo "🗄️ Running database migrations..."
php artisan migrate --force --env=production

# Seed database
echo "🌱 Seeding database..."
php artisan db:seed --force --env=production

# Clear and cache configurations
echo "⚡ Optimizing application..."
php artisan config:clear
php artisan config:cache
php artisan route:clear
php artisan route:cache
php artisan view:clear
php artisan view:cache

# Set proper permissions
echo "🔒 Setting permissions..."
chmod -R 755 storage
chmod -R 755 bootstrap/cache
chown -R www-data:www-data storage
chown -R www-data:www-data bootstrap/cache

# Create storage symlink
echo "🔗 Creating storage symlink..."
php artisan storage:link

# Generate API documentation
echo "📚 Generating API documentation..."
# You can add API documentation generation here if needed

echo "✅ Deployment completed successfully!"
echo ""
echo "📋 Post-deployment checklist:"
echo "1. Update .env.production with your production database credentials"
echo "2. Configure your web server (Apache/Nginx) to point to the public directory"
echo "3. Set up SSL certificates for HTTPS"
echo "4. Configure your domain in CORS settings"
echo "5. Test all API endpoints"
echo "6. Set up monitoring and logging"
echo ""
echo "🌐 Your API will be available at: https://yourdomain.com/api/mobile"
echo "📱 Flutter app should connect to: https://yourdomain.com/api/mobile"

























