<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\PermissionRegistrar;

class PermissionsSeeder extends Seeder
{
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        // Delete all existing roles except super-admin and user
        Role::whereNotIn('name', ['super-admin', 'user'])->delete();

        // Patient Management Permissions
        Permission::firstOrCreate(['name' => 'list patients']);
        Permission::firstOrCreate(['name' => 'view patients']);
        Permission::firstOrCreate(['name' => 'create patients']);
        Permission::firstOrCreate(['name' => 'update patients']);
        Permission::firstOrCreate(['name' => 'delete patients']);

        // Category Permissions
        Permission::firstOrCreate(['name' => 'list categories']);
        Permission::firstOrCreate(['name' => 'view categories']);
        Permission::firstOrCreate(['name' => 'create categories']);
        Permission::firstOrCreate(['name' => 'update categories']);
        Permission::firstOrCreate(['name' => 'delete categories']);

        // Subcategory Permissions
        Permission::firstOrCreate(['name' => 'list subcategories']);
        Permission::firstOrCreate(['name' => 'view subcategories']);
        Permission::firstOrCreate(['name' => 'create subcategories']);
        Permission::firstOrCreate(['name' => 'update subcategories']);
        Permission::firstOrCreate(['name' => 'delete subcategories']);

        // Product Permissions
        Permission::firstOrCreate(['name' => 'list products']);
        Permission::firstOrCreate(['name' => 'view products']);
        Permission::firstOrCreate(['name' => 'create products']);
        Permission::firstOrCreate(['name' => 'update products']);
        Permission::firstOrCreate(['name' => 'delete products']);

        // Supplier Permissions
        Permission::firstOrCreate(['name' => 'list suppliers']);
        Permission::firstOrCreate(['name' => 'view suppliers']);
        Permission::firstOrCreate(['name' => 'create suppliers']);
        Permission::firstOrCreate(['name' => 'update suppliers']);
        Permission::firstOrCreate(['name' => 'delete suppliers']);

        // Product Batch Permissions
        Permission::firstOrCreate(['name' => 'list productbatches']);
        Permission::firstOrCreate(['name' => 'view productbatches']);
        Permission::firstOrCreate(['name' => 'create productbatches']);
        Permission::firstOrCreate(['name' => 'update productbatches']);
        Permission::firstOrCreate(['name' => 'delete productbatches']);

        // Invoice Permissions
        Permission::firstOrCreate(['name' => 'list invoices']);
        Permission::firstOrCreate(['name' => 'view invoices']);
        Permission::firstOrCreate(['name' => 'create invoices']);
        Permission::firstOrCreate(['name' => 'update invoices']);
        Permission::firstOrCreate(['name' => 'delete invoices']);

        // Invoice Item Permissions
        Permission::firstOrCreate(['name' => 'list invoiceitems']);
        Permission::firstOrCreate(['name' => 'view invoiceitems']);
        Permission::firstOrCreate(['name' => 'create invoiceitems']);
        Permission::firstOrCreate(['name' => 'update invoiceitems']);
        Permission::firstOrCreate(['name' => 'delete invoiceitems']);

        // Patient History Permissions
        Permission::firstOrCreate(['name' => 'list patienthistories']);
        Permission::firstOrCreate(['name' => 'view patienthistories']);
        Permission::firstOrCreate(['name' => 'create patienthistories']);
        Permission::firstOrCreate(['name' => 'update patienthistories']);
        Permission::firstOrCreate(['name' => 'delete patienthistories']);

        // Create admin exclusive permissions
        Permission::firstOrCreate(['name' => 'list roles']);
        Permission::firstOrCreate(['name' => 'view roles']);
        Permission::firstOrCreate(['name' => 'create roles']);
        Permission::firstOrCreate(['name' => 'update roles']);
        Permission::firstOrCreate(['name' => 'delete roles']);

        Permission::firstOrCreate(['name' => 'list permissions']);
        Permission::firstOrCreate(['name' => 'view permissions']);
        Permission::firstOrCreate(['name' => 'create permissions']);
        Permission::firstOrCreate(['name' => 'update permissions']);
        Permission::firstOrCreate(['name' => 'delete permissions']);

        Permission::firstOrCreate(['name' => 'list users']);
        Permission::firstOrCreate(['name' => 'view users']);
        Permission::firstOrCreate(['name' => 'create users']);
        Permission::firstOrCreate(['name' => 'update users']);
        Permission::firstOrCreate(['name' => 'delete users']);

        // Create super-admin role and assign all permissions
        $allPermissions = Permission::all();
        $superAdminRole = Role::firstOrCreate(['name' => 'super-admin']);
        $superAdminRole->syncPermissions($allPermissions);

        // Create user role with limited permissions
        // User can only: view/list/create patients and invoices (NO update/delete)
        // User can view patient report
        $userPermissions = [
            'list patients',
            'view patients',
            'create patients',
            'list invoices',
            'view invoices',
            'create invoices',
        ];
        
        $userRole = Role::firstOrCreate(['name' => 'user']);
        $userRole->syncPermissions($userPermissions);

        // Assign super-admin role to admin user
        $user = \App\Models\User::whereEmail('admin@admin.com')->first();

        if ($user) {
            $user->assignRole($superAdminRole);
        }
    }
}
