<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AppVersion;
use Illuminate\Support\Facades\DB;

class AppVersionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Clear existing versions
        DB::table('app_versions')->truncate();

        // Android version
        AppVersion::create([
            'version' => '1.0.15',
            'version_code' => 15,
            'platform' => 'android',
            'release_notes' => "• Fixed notification preferences API routes\n• Improved biometric authentication flow\n• Bug fixes and performance improvements",
            'download_url' => 'https://play.google.com/store/apps/details?id=com.Double Hair.mobile',
            'min_supported_version' => '1.0.0',
            'is_active' => true,
            'is_force_update' => false, // Set to true to force users to update
        ]);

        // iOS version
        AppVersion::create([
            'version' => '1.0.15',
            'version_code' => 15,
            'platform' => 'ios',
            'release_notes' => "• Fixed notification preferences API routes\n• Improved biometric authentication flow\n• Bug fixes and performance improvements",
            'download_url' => 'https://apps.apple.com/app/Double Hair/id123456789', // Replace with actual App Store ID
            'min_supported_version' => '1.0.0',
            'is_active' => true,
            'is_force_update' => false,
        ]);

        $this->command->info('✅ App versions seeded successfully!');
    }
}

