<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // First, ensure the database connection uses UTF-8
        DB::statement('SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci');
        
        // Update the customers table charset and collation
        DB::statement('ALTER TABLE customers CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
        
        // Update specific columns that store Kurdish text in customers table
        Schema::table('customers', function (Blueprint $table) {
            // Update customer_name column to support Kurdish text properly
            $table->string('customer_name')->charset('utf8mb4')->collation('utf8mb4_unicode_ci')->change();
            
            // Update phone_number column
            $table->string('phone_number')->charset('utf8mb4')->collation('utf8mb4_unicode_ci')->change();
            
            // Update second_phone column
            $table->string('second_phone')->charset('utf8mb4')->collation('utf8mb4_unicode_ci')->nullable()->change();
            
            // Update address column to support Kurdish text properly
            $table->string('address')->charset('utf8mb4')->collation('utf8mb4_unicode_ci')->change();
            
            // Update note column to support Kurdish text properly
            $table->text('note')->charset('utf8mb4')->collation('utf8mb4_unicode_ci')->nullable()->change();
        });
        
        // Update the users table charset and collation (since customer name is also stored in users.name)
        DB::statement('ALTER TABLE users CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
        
        // Update specific columns that store Kurdish text in users table
        Schema::table('users', function (Blueprint $table) {
            // Update name column to support Kurdish text properly
            $table->string('name')->charset('utf8mb4')->collation('utf8mb4_unicode_ci')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert customers table to default charset
        DB::statement('ALTER TABLE customers CONVERT TO CHARACTER SET utf8 COLLATE utf8_general_ci');
        
        Schema::table('customers', function (Blueprint $table) {
            $table->string('customer_name')->charset('utf8')->collation('utf8_general_ci')->change();
            $table->string('phone_number')->charset('utf8')->collation('utf8_general_ci')->change();
            $table->string('second_phone')->charset('utf8')->collation('utf8_general_ci')->nullable()->change();
            $table->string('address')->charset('utf8')->collation('utf8_general_ci')->change();
            $table->text('note')->charset('utf8')->collation('utf8_general_ci')->nullable()->change();
        });
        
        // Revert users table to default charset
        DB::statement('ALTER TABLE users CONVERT TO CHARACTER SET utf8 COLLATE utf8_general_ci');
        
        Schema::table('users', function (Blueprint $table) {
            $table->string('name')->charset('utf8')->collation('utf8_general_ci')->change();
        });
    }
};
