<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('app_versions', function (Blueprint $table) {
            $table->id();
            $table->string('version'); // e.g., "1.2.3"
            $table->integer('version_code'); // e.g., 123 (for version comparison)
            $table->enum('platform', ['android', 'ios']);
            $table->text('release_notes')->nullable();
            $table->string('download_url')->nullable(); // App store URL
            $table->string('min_supported_version')->nullable(); // Minimum version that can still use the app
            $table->boolean('is_active')->default(true);
            $table->boolean('is_force_update')->default(false);
            $table->timestamps();
            
            // Indexes for better performance
            $table->index(['platform', 'version_code']);
            $table->index(['platform', 'is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('app_versions');
    }
};
