<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up() {
        Schema::create('currency_trades', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('buy_transaction_id'); // Reference to the purchase transaction
            $table->unsignedBigInteger('sell_transaction_id')->nullable(); // Reference to the sale transaction
            $table->decimal('buy_rate', 10, 4); // The rate at which Tuman was bought
            $table->decimal('sell_rate', 10, 4)->nullable(); // The rate at which Tuman was sold
            $table->decimal('profit', 12, 4)->nullable(); // Profit calculation
            $table->timestamps();

            $table->foreign('buy_transaction_id')->references('id')->on('account_transactions')->onDelete('cascade');
            $table->foreign('sell_transaction_id')->references('id')->on('account_transactions')->onDelete('cascade');
        });
    }

    public function down() {
        Schema::dropIfExists('currency_trades');
    }
};
