<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->unsignedBigInteger('customer_id')->nullable()->change(); // Make customer_id nullable
        });

        Schema::table('account_transactions', function (Blueprint $table) {
            $table->unsignedBigInteger('from_account_id')->nullable()->change(); // Make from_account_id nullable
        });

        // Insert the Business Owner Cashbox account
        // DB::table('accounts')->insert([
        //     'account_title' => 'Business Owner Cashbox',
        //     'account_number' => '1000001',
        //     'balance' => 0,
        //     'customer_id' => null, // No customer
        //     'currency_id' => 1, // Adjust based on your default currency
        //     'account_type' => 'savings',
        //     'created_at' => now(),
        //     'updated_at' => now(),
        // ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->unsignedBigInteger('customer_id')->nullable(false)->change(); // Revert customer_id to NOT NULL
        });

        Schema::table('account_transactions', function (Blueprint $table) {
            $table->unsignedBigInteger('from_account_id')->nullable(false)->change(); // Revert from_account_id to NOT NULL
        });

        // Remove the Business Owner Cashbox account
        // DB::table('accounts')->where('account_number', '1000001')->delete();
    }
};
