<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('transaction_fees', function (Blueprint $table) {
            $table->decimal('fee_amount', 15, 4)->change(); // Update precision to 15,4
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transaction_fees', function (Blueprint $table) {
            $table->decimal('fee_amount', 15, 2)->change(); // Revert back to 15,2
        });
    }
};
