<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->boolean('notifications_enabled')->default(true);
            $table->boolean('transaction_notifications')->default(true);
            $table->boolean('currency_rate_notifications')->default(true);
            $table->boolean('account_update_notifications')->default(true);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'notifications_enabled',
                'transaction_notifications',
                'currency_rate_notifications',
                'account_update_notifications'
            ]);
        });
    }
};
